/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.BytesReader;
import internal.bytes.Record;
import internal.bytes.Seq;
import internal.ri.base.PageHeader;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderLocation;
import java.nio.ByteOrder;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RowIndex
implements SubHeader {
    @lombok.NonNull
    private final SubHeaderLocation location;
    private final @NonNegative int rowNumber;
    @lombok.NonNull
    private final SubHeaderLocation lastRowLocation;
    private static final Seq SEQ = Seq.builder().and("rowNumber", Seq.U4U8).and("lastRowLocation", SubHeaderLocation.SEQ).build();

    public static @NonNull List<RowIndex> parseAll(@NonNull PageHeader page, @NonNull BytesReader pageBytes, boolean u64) {
        short count = page.getSubHeaderCount();
        int offset = RowIndex.getPageOffset(page, u64, pageBytes);
        int length = RowIndex.getLength(u64);
        return Record.toList((int)count, offset, length, RowIndex.getFactory(page.getIndex(), pageBytes, u64));
    }

    private static int getPageOffset(PageHeader page, boolean u64, BytesReader pageBytes) {
        int requiredLength = RowIndex.getLength(u64) * page.getSubHeaderCount();
        int availableLength = pageBytes.getLength();
        int base = PageHeader.getHeadLength(u64) + (u64 ? 8 : 4);
        int offset = page.getSubHeaderOffset();
        int align = 4;
        int result = base + offset;
        if (!u64 & PageHeader.canAlign(requiredLength, availableLength, base, offset, align)) {
            result += align;
        }
        return result;
    }

    private static Record.BiIntFunction<RowIndex> getFactory(int pageIndex, BytesReader pageBytes, boolean u64) {
        BytesReader bigEndian = pageBytes.duplicate(ByteOrder.BIG_ENDIAN);
        return (i, base) -> new RowIndex(new SubHeaderLocation(pageIndex, i), Seq.parseU4U8(bigEndian, base + SEQ.getOffset(u64, 0), u64), SubHeaderLocation.parse(pageBytes, base + SEQ.getOffset(u64, 1), u64));
    }

    private static int getLength(boolean u64) {
        return SEQ.getTotalLength(u64);
    }

    public RowIndex(@lombok.NonNull SubHeaderLocation location, @NonNegative int rowNumber, @lombok.NonNull SubHeaderLocation lastRowLocation) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (lastRowLocation == null) {
            throw new NullPointerException("lastRowLocation is marked non-null but is null");
        }
        this.location = location;
        this.rowNumber = rowNumber;
        this.lastRowLocation = lastRowLocation;
    }

    @Override
    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    public @NonNegative int getRowNumber() {
        return this.rowNumber;
    }

    @lombok.NonNull
    public SubHeaderLocation getLastRowLocation() {
        return this.lastRowLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RowIndex)) {
            return false;
        }
        RowIndex other = (RowIndex)o;
        if (this.getRowNumber() != other.getRowNumber()) {
            return false;
        }
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        SubHeaderLocation this$lastRowLocation = this.getLastRowLocation();
        SubHeaderLocation other$lastRowLocation = other.getLastRowLocation();
        return !(this$lastRowLocation == null ? other$lastRowLocation != null : !((Object)this$lastRowLocation).equals(other$lastRowLocation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRowNumber();
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        SubHeaderLocation $lastRowLocation = this.getLastRowLocation();
        result = result * 59 + ($lastRowLocation == null ? 43 : ((Object)$lastRowLocation).hashCode());
        return result;
    }

    public String toString() {
        return "RowIndex(location=" + this.getLocation() + ", rowNumber=" + this.getRowNumber() + ", lastRowLocation=" + this.getLastRowLocation() + ")";
    }
}

