/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.PValue;

public enum PageType {
    META,
    DATA,
    MIX,
    AMD,
    METC,
    INDEX;


    public boolean hasMeta() {
        return this == META || this == MIX || this == AMD;
    }

    public static PValue<PageType, Short> tryParse(short value) {
        switch (value) {
            case 0: 
            case 128: {
                return PValue.known(META);
            }
            case 256: 
            case 384: {
                return PValue.known(DATA);
            }
            case 512: 
            case 640: {
                return PValue.known(MIX);
            }
            case 1024: {
                return PValue.known(AMD);
            }
            case 16384: {
                return PValue.known(METC);
            }
            case -28672: {
                return PValue.known(INDEX);
            }
        }
        return PValue.unknown(value);
    }
}

