/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.BytesReader;
import internal.bytes.PValue;
import internal.bytes.Seq;
import internal.ri.base.PageType;
import internal.ri.base.SubHeaderLocation;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PageHeader {
    private final @NonNegative int index;
    private final short deletedOffset;
    private final @NonNull PValue<PageType, Short> type;
    private final @NonNegative short dataBlockCount;
    private final @NonNegative short subHeaderCount;
    private final @NonNegative int subHeaderOffset;
    public static final Seq SEQ = Seq.builder().and("signature", 4).and("?", 8, 20).and("deletedOffset", 4, 8).and("type", 2).and("dataBlockCount", 2).and("subHeaderCount", 2).and("subHeaderOffset", 2).build();

    public @NonNull SubHeaderLocation getSubHeaderLocation(int subHeaderIndex) {
        return new SubHeaderLocation(this.index, subHeaderIndex);
    }

    public static @NonNull PageHeader parse(@NonNull BytesReader pageBytes, boolean u64, int index) {
        short deletedOffset = pageBytes.getInt16(SEQ.getOffset(u64, 2));
        short type = pageBytes.getInt16(SEQ.getOffset(u64, 3));
        short dataBlockCount = pageBytes.getInt16(SEQ.getOffset(u64, 4));
        short subHeaderCount = pageBytes.getInt16(SEQ.getOffset(u64, 5));
        int subHeaderOffset = pageBytes.getUInt16(SEQ.getOffset(u64, 6));
        return new PageHeader(index, deletedOffset, PageType.tryParse(type), dataBlockCount, subHeaderCount, subHeaderOffset);
    }

    public static boolean canAlign(@NonNegative int requiredLength, @NonNegative int availableLength, @NonNegative int base, @NonNegative int offset, @NonNegative int align) {
        return availableLength - (base + offset + align) >= requiredLength;
    }

    public static int getHeadLength(boolean u64) {
        return SEQ.getTotalLength(u64);
    }

    public PageHeader(@NonNegative int index, short deletedOffset, @NonNull PValue<PageType, Short> type, @NonNegative short dataBlockCount, @NonNegative short subHeaderCount, @NonNegative int subHeaderOffset) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.index = index;
        this.deletedOffset = deletedOffset;
        this.type = type;
        this.dataBlockCount = dataBlockCount;
        this.subHeaderCount = subHeaderCount;
        this.subHeaderOffset = subHeaderOffset;
    }

    public @NonNegative int getIndex() {
        return this.index;
    }

    public short getDeletedOffset() {
        return this.deletedOffset;
    }

    public @NonNull PValue<PageType, Short> getType() {
        return this.type;
    }

    public @NonNegative short getDataBlockCount() {
        return this.dataBlockCount;
    }

    public @NonNegative short getSubHeaderCount() {
        return this.subHeaderCount;
    }

    public @NonNegative int getSubHeaderOffset() {
        return this.subHeaderOffset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageHeader)) {
            return false;
        }
        PageHeader other = (PageHeader)o;
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getDeletedOffset() != other.getDeletedOffset()) {
            return false;
        }
        if (this.getDataBlockCount() != other.getDataBlockCount()) {
            return false;
        }
        if (this.getSubHeaderCount() != other.getSubHeaderCount()) {
            return false;
        }
        if (this.getSubHeaderOffset() != other.getSubHeaderOffset()) {
            return false;
        }
        PValue<PageType, Short> this$type = this.getType();
        PValue<PageType, Short> other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getDeletedOffset();
        result = result * 59 + this.getDataBlockCount();
        result = result * 59 + this.getSubHeaderCount();
        result = result * 59 + this.getSubHeaderOffset();
        PValue<PageType, Short> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public String toString() {
        return "PageHeader(index=" + this.getIndex() + ", deletedOffset=" + this.getDeletedOffset() + ", type=" + this.getType() + ", dataBlockCount=" + this.getDataBlockCount() + ", subHeaderCount=" + this.getSubHeaderCount() + ", subHeaderOffset=" + this.getSubHeaderOffset() + ")";
    }
}

