/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.bytes.SeekableCursor;
import internal.ri.base.Header;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PageCursor
implements SeekableCursor {
    @lombok.NonNull
    private final SeekableByteChannel sbc;
    private final @NonNegative int headerLength;
    private final @NonNegative int pageLength;
    private final int count;
    private final Bytes bytes;
    private int index;

    public static @NonNull PageCursor of(@NonNull SeekableByteChannel sbc, @NonNull Header header) {
        return new PageCursor(sbc, header.getLength(), header.getPageLength(), header.getPageCount(), PageCursor.allocatePageBytes(header), -1);
    }

    private static Bytes allocatePageBytes(Header header) {
        return Bytes.allocate(header.getPageLength(), header.getEndianness());
    }

    @Override
    public void moveTo(int index) throws IOException {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        this.index = index;
        this.bytes.fill(this.sbc, this.getPagePosition());
    }

    private int getPagePosition() {
        return this.headerLength + this.pageLength * this.index;
    }

    public static @NonNull BytesReader getBytes(@NonNull SeekableByteChannel file, @NonNull Header header, @NonNegative int pageIndex) throws IOException {
        PageCursor cursor = PageCursor.of(file, header);
        cursor.moveTo(pageIndex);
        return cursor.getBytes();
    }

    private PageCursor(@lombok.NonNull SeekableByteChannel sbc, @NonNegative int headerLength, @NonNegative int pageLength, int count, Bytes bytes, int index) {
        if (sbc == null) {
            throw new NullPointerException("sbc is marked non-null but is null");
        }
        this.sbc = sbc;
        this.headerLength = headerLength;
        this.pageLength = pageLength;
        this.count = count;
        this.bytes = bytes;
        this.index = index;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Bytes getBytes() {
        return this.bytes;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

