/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.bytes.PValue;
import internal.bytes.Seq;
import internal.ri.base.Encoding;
import internal.ri.base.Platform;
import internal.ri.base.SasCalendar;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import sasquatch.util.SasFileTypeDetector;

public final class Header {
    private final boolean u64;
    private final @NonNull ByteOrder endianness;
    private final @NonNull PValue<Platform, Character> platform;
    private final @NonNull PValue<Encoding, Short> encoding;
    private final @NonNull LocalDateTime creationTime;
    private final @NonNull LocalDateTime lastModificationTime;
    private final @NonNegative int length;
    private final @NonNegative int pageLength;
    private final @NonNegative int pageCount;
    private final @NonNull String sasRelease;
    private final @NonNull String sasHost;
    private final @NonNull String osVersion;
    private final @NonNull String osMaker;
    private final @NonNull String osName;
    private final @NonNull String name;
    private final @NonNull String fileType;
    private static final int MIN_LENGTH = 296;

    public static @NonNull Header parse(@NonNull Path file) throws IOException {
        try (SeekableByteChannel sbc = Files.newByteChannel(file, StandardOpenOption.READ);){
            Header header = Header.parse(sbc);
            return header;
        }
    }

    public static @NonNull Header parse(@NonNull SeekableByteChannel sbc) throws IOException {
        Header.checkFileSize(sbc);
        Bytes file = Bytes.allocate(296, ByteOrder.nativeOrder());
        file.fill(sbc, 0L);
        Header.checkMagicNumber(file);
        return Header.parse(file);
    }

    private static Header parse(BytesReader file) throws IOException {
        boolean u64 = file.getByte(32) == 51;
        int align1 = file.getByte(35) == 51 ? 4 : 0;
        ByteOrder endianness = Header.readEndianness(file.getByte(37));
        file = file.duplicate(endianness);
        char platform = file.getString(39, 1, StandardCharsets.US_ASCII).charAt(0);
        short encoding = file.getUInt8(70);
        String name = file.getString(92, 64, StandardCharsets.US_ASCII);
        String fileType = file.getString(156, 8, StandardCharsets.US_ASCII);
        double creationTime = file.getFloat64(164 + align1);
        double lastModificationTime = file.getFloat64(172 + align1);
        int length = file.getInt32(196 + align1);
        int pageLength = file.getInt32(200 + align1);
        int pageCount = Seq.parseU4U8(file, 204 + align1, u64);
        int align2 = u64 ? 4 : 0;
        String sasRelease = file.getString(216 + align1 + align2, 8, StandardCharsets.US_ASCII);
        String sasHost = file.getString(224 + align1 + align2, 8, StandardCharsets.US_ASCII);
        String osVersion = file.getString(240 + align1 + align2, 16, StandardCharsets.US_ASCII);
        String osMaker = file.getString(256 + align1 + align2, 16, StandardCharsets.US_ASCII);
        String osName = file.getString(272 + align1 + align2, 16, StandardCharsets.US_ASCII);
        return new Header(u64, endianness, Platform.tryParse(platform), Encoding.tryParse(encoding), SasCalendar.getDateTime(creationTime), SasCalendar.getDateTime(lastModificationTime), length, pageLength, pageCount, sasRelease, sasHost, osVersion, osMaker, osName, name, fileType);
    }

    private static void checkFileSize(SeekableByteChannel sbc) throws IOException {
        if (sbc.size() < 296L) {
            throw new IOException("Header too short: expected=296, actual=" + sbc.size());
        }
    }

    private static void checkMagicNumber(BytesReader file) throws IOException {
        if (!SasFileTypeDetector.isSasId((byte[])file.getBytes(0, 32))) {
            throw new IOException("Magic number mismatch");
        }
    }

    private static ByteOrder readEndianness(byte value) throws IOException {
        switch (value) {
            case 0: {
                return ByteOrder.BIG_ENDIAN;
            }
            case 1: {
                return ByteOrder.LITTLE_ENDIAN;
            }
        }
        throw new IOException(String.format("Unknown endianness: %02X ", value));
    }

    public Header(boolean u64, @NonNull ByteOrder endianness, @NonNull PValue<Platform, Character> platform, @NonNull PValue<Encoding, Short> encoding, @NonNull LocalDateTime creationTime, @NonNull LocalDateTime lastModificationTime, @NonNegative int length, @NonNegative int pageLength, @NonNegative int pageCount, @NonNull String sasRelease, @NonNull String sasHost, @NonNull String osVersion, @NonNull String osMaker, @NonNull String osName, @NonNull String name, @NonNull String fileType) {
        if (endianness == null) {
            throw new NullPointerException("endianness is marked non-null but is null");
        }
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        if (creationTime == null) {
            throw new NullPointerException("creationTime is marked non-null but is null");
        }
        if (lastModificationTime == null) {
            throw new NullPointerException("lastModificationTime is marked non-null but is null");
        }
        if (sasRelease == null) {
            throw new NullPointerException("sasRelease is marked non-null but is null");
        }
        if (sasHost == null) {
            throw new NullPointerException("sasHost is marked non-null but is null");
        }
        if (osVersion == null) {
            throw new NullPointerException("osVersion is marked non-null but is null");
        }
        if (osMaker == null) {
            throw new NullPointerException("osMaker is marked non-null but is null");
        }
        if (osName == null) {
            throw new NullPointerException("osName is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        this.u64 = u64;
        this.endianness = endianness;
        this.platform = platform;
        this.encoding = encoding;
        this.creationTime = creationTime;
        this.lastModificationTime = lastModificationTime;
        this.length = length;
        this.pageLength = pageLength;
        this.pageCount = pageCount;
        this.sasRelease = sasRelease;
        this.sasHost = sasHost;
        this.osVersion = osVersion;
        this.osMaker = osMaker;
        this.osName = osName;
        this.name = name;
        this.fileType = fileType;
    }

    public boolean isU64() {
        return this.u64;
    }

    public @NonNull ByteOrder getEndianness() {
        return this.endianness;
    }

    public @NonNull PValue<Platform, Character> getPlatform() {
        return this.platform;
    }

    public @NonNull PValue<Encoding, Short> getEncoding() {
        return this.encoding;
    }

    public @NonNull LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public @NonNull LocalDateTime getLastModificationTime() {
        return this.lastModificationTime;
    }

    public @NonNegative int getLength() {
        return this.length;
    }

    public @NonNegative int getPageLength() {
        return this.pageLength;
    }

    public @NonNegative int getPageCount() {
        return this.pageCount;
    }

    public @NonNull String getSasRelease() {
        return this.sasRelease;
    }

    public @NonNull String getSasHost() {
        return this.sasHost;
    }

    public @NonNull String getOsVersion() {
        return this.osVersion;
    }

    public @NonNull String getOsMaker() {
        return this.osMaker;
    }

    public @NonNull String getOsName() {
        return this.osName;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getFileType() {
        return this.fileType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header other = (Header)o;
        if (this.isU64() != other.isU64()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getPageLength() != other.getPageLength()) {
            return false;
        }
        if (this.getPageCount() != other.getPageCount()) {
            return false;
        }
        ByteOrder this$endianness = this.getEndianness();
        ByteOrder other$endianness = other.getEndianness();
        if (this$endianness == null ? other$endianness != null : !this$endianness.equals(other$endianness)) {
            return false;
        }
        PValue<Platform, Character> this$platform = this.getPlatform();
        PValue<Platform, Character> other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !((Object)this$platform).equals(other$platform)) {
            return false;
        }
        PValue<Encoding, Short> this$encoding = this.getEncoding();
        PValue<Encoding, Short> other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !((Object)this$encoding).equals(other$encoding)) {
            return false;
        }
        LocalDateTime this$creationTime = this.getCreationTime();
        LocalDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        LocalDateTime this$lastModificationTime = this.getLastModificationTime();
        LocalDateTime other$lastModificationTime = other.getLastModificationTime();
        if (this$lastModificationTime == null ? other$lastModificationTime != null : !((Object)this$lastModificationTime).equals(other$lastModificationTime)) {
            return false;
        }
        String this$sasRelease = this.getSasRelease();
        String other$sasRelease = other.getSasRelease();
        if (this$sasRelease == null ? other$sasRelease != null : !this$sasRelease.equals(other$sasRelease)) {
            return false;
        }
        String this$sasHost = this.getSasHost();
        String other$sasHost = other.getSasHost();
        if (this$sasHost == null ? other$sasHost != null : !this$sasHost.equals(other$sasHost)) {
            return false;
        }
        String this$osVersion = this.getOsVersion();
        String other$osVersion = other.getOsVersion();
        if (this$osVersion == null ? other$osVersion != null : !this$osVersion.equals(other$osVersion)) {
            return false;
        }
        String this$osMaker = this.getOsMaker();
        String other$osMaker = other.getOsMaker();
        if (this$osMaker == null ? other$osMaker != null : !this$osMaker.equals(other$osMaker)) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        return !(this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isU64() ? 79 : 97);
        result = result * 59 + this.getLength();
        result = result * 59 + this.getPageLength();
        result = result * 59 + this.getPageCount();
        ByteOrder $endianness = this.getEndianness();
        result = result * 59 + ($endianness == null ? 43 : $endianness.hashCode());
        PValue<Platform, Character> $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : ((Object)$platform).hashCode());
        PValue<Encoding, Short> $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : ((Object)$encoding).hashCode());
        LocalDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        LocalDateTime $lastModificationTime = this.getLastModificationTime();
        result = result * 59 + ($lastModificationTime == null ? 43 : ((Object)$lastModificationTime).hashCode());
        String $sasRelease = this.getSasRelease();
        result = result * 59 + ($sasRelease == null ? 43 : $sasRelease.hashCode());
        String $sasHost = this.getSasHost();
        result = result * 59 + ($sasHost == null ? 43 : $sasHost.hashCode());
        String $osVersion = this.getOsVersion();
        result = result * 59 + ($osVersion == null ? 43 : $osVersion.hashCode());
        String $osMaker = this.getOsMaker();
        result = result * 59 + ($osMaker == null ? 43 : $osMaker.hashCode());
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        return result;
    }

    public String toString() {
        return "Header(u64=" + this.isU64() + ", endianness=" + this.getEndianness() + ", platform=" + this.getPlatform() + ", encoding=" + this.getEncoding() + ", creationTime=" + this.getCreationTime() + ", lastModificationTime=" + this.getLastModificationTime() + ", length=" + this.getLength() + ", pageLength=" + this.getPageLength() + ", pageCount=" + this.getPageCount() + ", sasRelease=" + this.getSasRelease() + ", sasHost=" + this.getSasHost() + ", osVersion=" + this.getOsVersion() + ", osMaker=" + this.getOsMaker() + ", osName=" + this.getOsName() + ", name=" + this.getName() + ", fileType=" + this.getFileType() + ")";
    }
}

