/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.PValue;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Encoding {
    public static final Encoding DEFAULT = new Encoding(0, "WINDOWS-1252");
    private static final Encoding[] ENCODINGS = Encoding.initEncodings();
    private final @NonNegative int code;
    @lombok.NonNull
    private final String charsetName;

    public static @NonNull PValue<Encoding, Short> tryParse(short uint8) {
        Encoding result = ENCODINGS[uint8];
        return result != null ? PValue.known(result) : PValue.unknown(uint8);
    }

    public String toString() {
        return this.charsetName;
    }

    public @NonNull Charset getCharset() throws IOException {
        try {
            return Charset.forName(this.charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            throw new IOException(ex);
        }
    }

    private static Encoding[] initEncodings() {
        Encoding[] result = new Encoding[256];
        result[0] = DEFAULT;
        result[20] = new Encoding(20, "UTF-8");
        result[28] = new Encoding(28, "US-ASCII");
        result[29] = new Encoding(29, "ISO-8859-1");
        result[30] = new Encoding(30, "ISO-8859-2");
        result[31] = new Encoding(31, "ISO-8859-3");
        result[32] = new Encoding(32, "ISO-8859-4");
        result[33] = new Encoding(33, "ISO-8859-5");
        result[34] = new Encoding(34, "ISO-8859-6");
        result[35] = new Encoding(35, "ISO-8859-7");
        result[36] = new Encoding(36, "ISO-8859-8");
        result[37] = new Encoding(37, "ISO-8859-9");
        result[39] = new Encoding(39, "x-iso-8859-11");
        result[40] = new Encoding(40, "ISO-8859-15");
        result[43] = new Encoding(43, "IBM437");
        result[44] = new Encoding(44, "IBM850");
        result[45] = new Encoding(45, "IBM852");
        result[46] = new Encoding(46, "IBM00858");
        result[47] = new Encoding(47, "IBM862");
        result[51] = new Encoding(51, "IBM866");
        result[58] = new Encoding(58, "IBM857");
        result[60] = new Encoding(60, "windows-1250");
        result[61] = new Encoding(61, "windows-1251");
        result[62] = new Encoding(62, "windows-1252");
        result[63] = new Encoding(63, "windows-1253");
        result[64] = new Encoding(64, "windows-1254");
        result[65] = new Encoding(65, "windows-1255");
        result[66] = new Encoding(66, "windows-1256");
        result[67] = new Encoding(67, "windows-1257");
        result[68] = new Encoding(68, "windows-1258");
        result[69] = new Encoding(69, "x-MacRoman");
        result[70] = new Encoding(70, "x-MacArabic");
        result[71] = new Encoding(71, "x-MacHebrew");
        result[72] = new Encoding(72, "x-MacGreek");
        result[73] = new Encoding(73, "x-MacThai");
        result[75] = new Encoding(75, "x-MacTurkish");
        result[76] = new Encoding(76, "x-MacUkraine");
        result[78] = new Encoding(78, "IBM037");
        result[87] = new Encoding(87, "IBM424");
        result[88] = new Encoding(88, "IBM500");
        result[89] = new Encoding(89, "IBM-Thai");
        result[90] = new Encoding(90, "IBM870");
        result[91] = new Encoding(91, "x-IBM875");
        result[95] = new Encoding(95, "x-IBM1025");
        result[98] = new Encoding(98, "x-IBM1112");
        result[99] = new Encoding(99, "x-IBM1122");
        result[102] = new Encoding(102, "IBM424");
        result[103] = new Encoding(103, "IBM-Thai");
        result[104] = new Encoding(104, "IBM870");
        result[105] = new Encoding(105, "x-IBM875");
        result[108] = new Encoding(108, "x-IBM1025");
        result[109] = new Encoding(109, "IBM1026");
        result[110] = new Encoding(110, "IBM1047");
        result[111] = new Encoding(111, "x-IBM1112");
        result[112] = new Encoding(112, "x-IBM1122");
        result[117] = new Encoding(117, "x-IBM937");
        result[118] = new Encoding(118, "x-windows-950");
        result[119] = new Encoding(119, "x-EUC-TW");
        result[123] = new Encoding(123, "Big5");
        result[124] = new Encoding(124, "x-IBM935");
        result[125] = new Encoding(125, "GBK");
        result[126] = new Encoding(126, "x-mswin-936");
        result[128] = new Encoding(128, "x-IBM1381");
        result[129] = new Encoding(129, "x-IBM939");
        result[130] = new Encoding(130, "x-IBM930");
        result[134] = new Encoding(134, "EUC-JP");
        result[136] = new Encoding(136, "x-windows-iso2022jp");
        result[137] = new Encoding(137, "x-IBM942");
        result[138] = new Encoding(138, "Shift_JIS");
        result[139] = new Encoding(139, "x-IBM933");
        result[140] = new Encoding(140, "EUC-KR");
        result[141] = new Encoding(141, "x-windows-949");
        result[142] = new Encoding(142, "x-IBM949");
        result[163] = new Encoding(163, "x-MacIceland");
        result[167] = new Encoding(167, "ISO-2022-JP");
        result[168] = new Encoding(168, "ISO-2022-KR");
        result[169] = new Encoding(169, "x-ISO2022-CN-GB");
        result[172] = new Encoding(172, "x-ISO2022-CN-CNS");
        result[173] = new Encoding(173, "IBM037");
        result[183] = new Encoding(183, "IBM01140");
        result[184] = new Encoding(184, "IBM01141");
        result[185] = new Encoding(185, "IBM01142");
        result[186] = new Encoding(186, "IBM01143");
        result[187] = new Encoding(187, "IBM01144");
        result[188] = new Encoding(188, "IBM01145");
        result[189] = new Encoding(189, "IBM01146");
        result[190] = new Encoding(190, "IBM01147");
        result[191] = new Encoding(191, "IBM01148");
        result[192] = new Encoding(192, "IBM01140");
        result[193] = new Encoding(193, "IBM01141");
        result[194] = new Encoding(194, "IBM01142");
        result[195] = new Encoding(195, "IBM01143");
        result[196] = new Encoding(196, "IBM01144");
        result[197] = new Encoding(197, "IBM01145");
        result[198] = new Encoding(198, "IBM01146");
        result[199] = new Encoding(199, "IBM01147");
        result[200] = new Encoding(200, "IBM01148");
        result[205] = new Encoding(205, "GB18030");
        result[207] = new Encoding(207, "x-IBM1097");
        result[208] = new Encoding(208, "x-IBM1097");
        result[211] = new Encoding(211, "IBM01149");
        result[212] = new Encoding(212, "IBM01149");
        result[234] = new Encoding(234, "x-IBM930");
        result[235] = new Encoding(235, "x-IBM933");
        result[236] = new Encoding(236, "x-IBM935");
        result[237] = new Encoding(237, "x-IBM937");
        result[238] = new Encoding(238, "x-IBM939");
        result[242] = new Encoding(242, "ISO-8859-13");
        result[245] = new Encoding(245, "x-MacCroatian");
        result[246] = new Encoding(246, "x-MacCyrillic");
        result[247] = new Encoding(247, "x-MacRomania");
        result[248] = new Encoding(248, "JIS_X0201");
        return result;
    }

    public Encoding(@NonNegative int code, @lombok.NonNull String charsetName) {
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        this.code = code;
        this.charsetName = charsetName;
    }

    public @NonNegative int getCode() {
        return this.code;
    }

    @lombok.NonNull
    public String getCharsetName() {
        return this.charsetName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Encoding)) {
            return false;
        }
        Encoding other = (Encoding)o;
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$charsetName = this.getCharsetName();
        String other$charsetName = other.getCharsetName();
        return !(this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $charsetName = this.getCharsetName();
        result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
        return result;
    }
}

