/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions.impl;

import internal.bytes.PValue;
import internal.ri.data.Compression;
import internal.ri.data.DescriptorType;
import internal.ri.data.Document;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class Util {
    static <T> boolean isSorted(List<T> list, Comparator<T> comparator) {
        return list.stream().sorted(comparator).collect(Collectors.toList()).equals(list);
    }

    static IntStream indexesOf(List<PValue<DescriptorType, String>> list, DescriptorType type) {
        return IntStream.range(0, list.size()).filter(i -> ((PValue)list.get(i)).isKnownAs(type));
    }

    static boolean isCompressed(SeekableByteChannel file) throws IOException {
        return Util.isCompressed(Document.parse(file));
    }

    static boolean isCompressed(Document doc) {
        return doc.getCompression().isKnownAs(Compression.CHAR) || doc.getCompression().isKnownAs(Compression.BIN);
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

