/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions.impl;

import internal.ri.assumptions.SasFileAssumption;
import internal.ri.assumptions.SasFileStructure;
import internal.ri.assumptions.impl.Util;
import internal.ri.data.DescriptorType;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.EnumSet;

public enum UniqueDescriptorAssumptions implements SasFileAssumption
{
    ROW_SIZE_UNIQUE_AT_0(DescriptorType.ROW_SIZE, 0),
    COL_SIZE_UNIQUE_AT_1(DescriptorType.COL_SIZE, 1),
    SUBH_CNT_UNIQUE_AT_2(DescriptorType.SUBH_CNT, 2);

    private final DescriptorType type;
    private final int index;

    @Override
    public String test(SeekableByteChannel file, SasFileStructure structure) {
        long actual = Util.indexesOf(structure.getDescriptorTypes(), this.type).count();
        if (actual != 1L) {
            return this.type + " count expected:1, actual:" + actual;
        }
        if (!structure.getDescriptorTypes().get(this.index).isKnownAs(this.type)) {
            return this.type + " expected at index " + this.index;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name();
    }

    private UniqueDescriptorAssumptions(DescriptorType type, int index) {
        this.type = type;
        this.index = index;
    }

    public static final class Provider
    implements SasFileAssumption.Provider {
        private final Collection<? extends SasFileAssumption> assumptions = EnumSet.allOf(UniqueDescriptorAssumptions.class);

        @Override
        public Collection<? extends SasFileAssumption> getAssumptions() {
            return this.assumptions;
        }
    }
}

