/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions.impl;

import internal.ri.assumptions.SasFileAssumption;
import internal.ri.assumptions.SasFileStructure;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.EnumSet;

public enum PageAssumptions implements SasFileAssumption
{
    FIRST_PAGE_META{

        @Override
        public String test(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            return !structure.getPages().get(0).getType().get().hasMeta() ? "First page always meta" : null;
        }
    }
    ,
    FILE_SIZE{

        @Override
        public String test(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            long expectedSize = structure.getHeader().getLength() + structure.getHeader().getPageCount() * structure.getHeader().getPageLength();
            return file.size() != expectedSize ? "Header + pages should be equal to file" : null;
        }
    };


    @Override
    public String getName() {
        return this.name();
    }

    public static final class Provider
    implements SasFileAssumption.Provider {
        private final Collection<? extends SasFileAssumption> assumptions = EnumSet.allOf(PageAssumptions.class);

        @Override
        public Collection<? extends SasFileAssumption> getAssumptions() {
            return this.assumptions;
        }
    }
}

