/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions.impl;

import internal.bytes.BytesReader;
import internal.bytes.PValue;
import internal.ri.assumptions.SasFileAssumption;
import internal.ri.assumptions.SasFileStructure;
import internal.ri.assumptions.impl.Util;
import internal.ri.base.PageCursor;
import internal.ri.base.SubHeaderFormat;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.DescriptorType;
import internal.ri.data.RowSize;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;

public enum LastMetaLocationAssumptions implements SasFileAssumption
{
    LAST_META_LOCATION;


    @Override
    public String test(SeekableByteChannel file, SasFileStructure structure) throws IOException {
        SubHeaderPointer lastMetaPointer;
        boolean u64;
        RowSize rowSize = this.getRowSize(file, structure);
        SubHeaderLocation lastMeta = rowSize.getLastMeta();
        BytesReader pageBytes = PageCursor.getBytes(file, structure.getHeader(), lastMeta.getPage());
        Optional<PValue<DescriptorType, String>> lastMetaType = DescriptorType.tryParse(pageBytes, u64 = structure.getHeader().isU64(), lastMetaPointer = SubHeaderPointer.parse(pageBytes, u64, lastMeta));
        if (!lastMetaType.isPresent()) {
            return "Expected last subheader type to be present";
        }
        if (lastMetaType.get().isUnknown()) {
            return "Expected last subheader type to be known";
        }
        SubHeaderLocation nextLocation = lastMeta.next();
        SubHeaderPointer nextPointer = SubHeaderPointer.parse(pageBytes, u64, nextLocation);
        Optional<PValue<DescriptorType, String>> nextType = DescriptorType.tryParse(pageBytes, u64, nextPointer);
        if (nextType.isPresent() && nextType.get().isKnown()) {
            return "Expected next subheader type to not be known";
        }
        if (Util.isCompressed(file) && !LastMetaLocationAssumptions.isRowOfCompressedFile(nextPointer, rowSize)) {
            return "Expected next subheader to be a data row";
        }
        return null;
    }

    private static boolean isRowOfCompressedFile(SubHeaderPointer nextPointer, RowSize rowSize) {
        return nextPointer.getFormat().isKnownAs(SubHeaderFormat.COMPRESSED) || nextPointer.getFormat().isKnownAs(SubHeaderFormat.PLAIN) && nextPointer.getLength() == rowSize.getLength();
    }

    private RowSize getRowSize(SeekableByteChannel file, SasFileStructure structure) throws IOException {
        if (structure.getPointers().size() < 1) {
            throw new IOException("Expecting structure pointer size >= 1");
        }
        return (RowSize)DescriptorType.ROW_SIZE.parse(file, structure.getHeader(), structure.getPointers().get(0));
    }

    @Override
    public String getName() {
        return this.name();
    }

    public static final class Provider
    implements SasFileAssumption.Provider {
        private final Collection<? extends SasFileAssumption> assumptions = EnumSet.allOf(LastMetaLocationAssumptions.class);

        @Override
        public Collection<? extends SasFileAssumption> getAssumptions() {
            return this.assumptions;
        }
    }
}

