/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions.impl;

import internal.bytes.BytesReader;
import internal.ri.assumptions.SasFileAssumption;
import internal.ri.assumptions.SasFileStructure;
import internal.ri.assumptions.impl.Util;
import internal.ri.base.Header;
import internal.ri.base.PageHeader;
import internal.ri.base.PageType;
import internal.ri.base.RowIndex;
import internal.ri.base.SasFile;
import internal.ri.base.SasFileVisitor;
import internal.ri.data.Document;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;

public enum CompressionAssumptions implements SasFileAssumption
{
    COMPRESSION_KNOWN{

        @Override
        public String test(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            Document doc = Document.parse(file);
            return !doc.getCompression().isKnown() ? "All compression IDs are known" : null;
        }
    }
    ,
    COMPRESSION_INDEX_UNIQUE{

        @Override
        public String test(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            if (Util.isCompressed(file)) {
                long count = structure.getPages().stream().filter(page -> page.getType().isKnownAs(PageType.INDEX)).count();
                return count != 1L ? "Compressed file has one page of type INDEX" : null;
            }
            return null;
        }
    }
    ,
    COMPRESSION_INDEX_SORTED{

        @Override
        public String test(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            if (Util.isCompressed(file)) {
                final ArrayList indexes = new ArrayList();
                SasFile.visit(file, new SasFileVisitor(){

                    @Override
                    public FileVisitResult onRowIndex(Header header, PageHeader page, BytesReader pageData, RowIndex rowIndex) {
                        indexes.add(rowIndex);
                        return FileVisitResult.CONTINUE;
                    }
                });
                return !Util.isSorted(indexes, Comparator.comparing(RowIndex::getLastRowLocation).reversed()) ? "isRowIndexesSorted" : null;
            }
            return null;
        }
    };


    @Override
    public String getName() {
        return this.name();
    }

    public static final class Provider
    implements SasFileAssumption.Provider {
        private final Collection<? extends SasFileAssumption> assumptions = EnumSet.allOf(CompressionAssumptions.class);

        @Override
        public Collection<? extends SasFileAssumption> getAssumptions() {
            return this.assumptions;
        }
    }
}

