/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions.impl;

import internal.ri.assumptions.SasFileAssumption;
import internal.ri.assumptions.SasFileStructure;
import internal.ri.assumptions.impl.Util;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.ColAttrs;
import internal.ri.data.ColNames;
import internal.ri.data.ColSize;
import internal.ri.data.DescriptorType;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.EnumSet;
import java.util.PrimitiveIterator;

public enum ColumnCountAssumptions implements SasFileAssumption
{
    COL_NAMES_COUNT(DescriptorType.COL_NAMES){

        @Override
        int countActual(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            int result = 0;
            PrimitiveIterator.OfInt iter = Util.indexesOf(structure.getDescriptorTypes(), DescriptorType.COL_NAMES).iterator();
            while (iter.hasNext()) {
                ColNames x = (ColNames)DescriptorType.COL_NAMES.parse(file, structure.getHeader(), structure.getPointers().get(iter.next()));
                result += x.getItems().size();
            }
            return result;
        }
    }
    ,
    COL_ATTRS_COUNT(DescriptorType.COL_ATTRS){

        @Override
        int countActual(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            int result = 0;
            PrimitiveIterator.OfInt iter = Util.indexesOf(structure.getDescriptorTypes(), DescriptorType.COL_ATTRS).iterator();
            while (iter.hasNext()) {
                ColAttrs x = (ColAttrs)DescriptorType.COL_ATTRS.parse(file, structure.getHeader(), structure.getPointers().get(iter.next()));
                result += x.getItems().size();
            }
            return result;
        }
    }
    ,
    COL_LABS_COUNT(DescriptorType.COL_LABS){

        @Override
        int countActual(SeekableByteChannel file, SasFileStructure structure) throws IOException {
            return (int)Util.indexesOf(structure.getDescriptorTypes(), DescriptorType.COL_LABS).count();
        }
    };

    private final DescriptorType type;

    abstract int countActual(SeekableByteChannel var1, SasFileStructure var2) throws IOException;

    @Override
    public String test(SeekableByteChannel file, SasFileStructure structure) throws IOException {
        int expected = this.getColCount(file, structure);
        long actual = this.countActual(file, structure);
        if (actual != (long)expected) {
            return this.type + " count expected:" + expected + ", actual:" + actual;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name();
    }

    private int getColCount(SeekableByteChannel file, SasFileStructure structure) throws IOException {
        if (structure.getPointers().size() < 2) {
            throw new IOException("Expecting structure pointer size >= 2");
        }
        SubHeaderPointer colSizePointer = structure.getPointers().get(1);
        return ((ColSize)DescriptorType.COL_SIZE.parse(file, structure.getHeader(), colSizePointer)).getCount();
    }

    private ColumnCountAssumptions(DescriptorType type) {
        this.type = type;
    }

    public static final class Provider
    implements SasFileAssumption.Provider {
        private final Collection<? extends SasFileAssumption> assumptions = EnumSet.allOf(ColumnCountAssumptions.class);

        @Override
        public Collection<? extends SasFileAssumption> getAssumptions() {
            return this.assumptions;
        }
    }
}

