/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions;

import internal.bytes.BytesReader;
import internal.bytes.PValue;
import internal.ri.base.Header;
import internal.ri.base.PageHeader;
import internal.ri.base.SasFile;
import internal.ri.base.SasFileVisitor;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.DescriptorType;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public final class SasFileStructure {
    @NonNull
    private final Header header;
    private final List<PageHeader> pages;
    private final List<SubHeaderPointer> pointers;
    private final List<PValue<DescriptorType, String>> descriptorTypes;
    private static final PValue<DescriptorType, String> NO_DESCRIPTOR_NULL = PValue.unknown("null");

    public static SasFileStructure of(SeekableByteChannel file) throws IOException {
        final Builder builder = SasFileStructure.builder();
        SasFile.visit(file, new SasFileVisitor(){

            @Override
            public FileVisitResult onHeader(Header header) {
                builder.header(header);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult onPage(Header header, PageHeader page, BytesReader pageData) {
                builder.page(page);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult onSubHeaderPointer(Header header, PageHeader page, BytesReader pageData, SubHeaderPointer pointer) {
                builder.pointer(pointer);
                builder.descriptorType(DescriptorType.tryParse(pageData, header.isU64(), pointer).orElse(NO_DESCRIPTOR_NULL));
                return FileVisitResult.CONTINUE;
            }
        });
        return builder.build();
    }

    SasFileStructure(@NonNull Header header, List<PageHeader> pages, List<SubHeaderPointer> pointers, List<PValue<DescriptorType, String>> descriptorTypes) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        this.header = header;
        this.pages = pages;
        this.pointers = pointers;
        this.descriptorTypes = descriptorTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public Header getHeader() {
        return this.header;
    }

    public List<PageHeader> getPages() {
        return this.pages;
    }

    public List<SubHeaderPointer> getPointers() {
        return this.pointers;
    }

    public List<PValue<DescriptorType, String>> getDescriptorTypes() {
        return this.descriptorTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SasFileStructure)) {
            return false;
        }
        SasFileStructure other = (SasFileStructure)o;
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List<PageHeader> this$pages = this.getPages();
        List<PageHeader> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        List<SubHeaderPointer> this$pointers = this.getPointers();
        List<SubHeaderPointer> other$pointers = other.getPointers();
        if (this$pointers == null ? other$pointers != null : !((Object)this$pointers).equals(other$pointers)) {
            return false;
        }
        List<PValue<DescriptorType, String>> this$descriptorTypes = this.getDescriptorTypes();
        List<PValue<DescriptorType, String>> other$descriptorTypes = other.getDescriptorTypes();
        return !(this$descriptorTypes == null ? other$descriptorTypes != null : !((Object)this$descriptorTypes).equals(other$descriptorTypes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List<PageHeader> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        List<SubHeaderPointer> $pointers = this.getPointers();
        result = result * 59 + ($pointers == null ? 43 : ((Object)$pointers).hashCode());
        List<PValue<DescriptorType, String>> $descriptorTypes = this.getDescriptorTypes();
        result = result * 59 + ($descriptorTypes == null ? 43 : ((Object)$descriptorTypes).hashCode());
        return result;
    }

    public String toString() {
        return "SasFileStructure(header=" + this.getHeader() + ", pages=" + this.getPages() + ", pointers=" + this.getPointers() + ", descriptorTypes=" + this.getDescriptorTypes() + ")";
    }

    public static class Builder {
        private Header header;
        private ArrayList<PageHeader> pages;
        private ArrayList<SubHeaderPointer> pointers;
        private ArrayList<PValue<DescriptorType, String>> descriptorTypes;

        Builder() {
        }

        public Builder header(@NonNull Header header) {
            if (header == null) {
                throw new NullPointerException("header is marked non-null but is null");
            }
            this.header = header;
            return this;
        }

        public Builder page(PageHeader page) {
            if (this.pages == null) {
                this.pages = new ArrayList();
            }
            this.pages.add(page);
            return this;
        }

        public Builder pages(Collection<? extends PageHeader> pages) {
            if (pages == null) {
                throw new NullPointerException("pages cannot be null");
            }
            if (this.pages == null) {
                this.pages = new ArrayList();
            }
            this.pages.addAll(pages);
            return this;
        }

        public Builder clearPages() {
            if (this.pages != null) {
                this.pages.clear();
            }
            return this;
        }

        public Builder pointer(SubHeaderPointer pointer) {
            if (this.pointers == null) {
                this.pointers = new ArrayList();
            }
            this.pointers.add(pointer);
            return this;
        }

        public Builder pointers(Collection<? extends SubHeaderPointer> pointers) {
            if (pointers == null) {
                throw new NullPointerException("pointers cannot be null");
            }
            if (this.pointers == null) {
                this.pointers = new ArrayList();
            }
            this.pointers.addAll(pointers);
            return this;
        }

        public Builder clearPointers() {
            if (this.pointers != null) {
                this.pointers.clear();
            }
            return this;
        }

        public Builder descriptorType(PValue<DescriptorType, String> descriptorType) {
            if (this.descriptorTypes == null) {
                this.descriptorTypes = new ArrayList();
            }
            this.descriptorTypes.add(descriptorType);
            return this;
        }

        public Builder descriptorTypes(Collection<? extends PValue<DescriptorType, String>> descriptorTypes) {
            if (descriptorTypes == null) {
                throw new NullPointerException("descriptorTypes cannot be null");
            }
            if (this.descriptorTypes == null) {
                this.descriptorTypes = new ArrayList();
            }
            this.descriptorTypes.addAll(descriptorTypes);
            return this;
        }

        public Builder clearDescriptorTypes() {
            if (this.descriptorTypes != null) {
                this.descriptorTypes.clear();
            }
            return this;
        }

        public SasFileStructure build() {
            List<PValue<DescriptorType, String>> descriptorTypes;
            List<SubHeaderPointer> pointers;
            List<PageHeader> pages;
            switch (this.pages == null ? 0 : this.pages.size()) {
                case 0: {
                    pages = Collections.emptyList();
                    break;
                }
                case 1: {
                    pages = Collections.singletonList(this.pages.get(0));
                    break;
                }
                default: {
                    pages = Collections.unmodifiableList(new ArrayList<PageHeader>(this.pages));
                }
            }
            switch (this.pointers == null ? 0 : this.pointers.size()) {
                case 0: {
                    pointers = Collections.emptyList();
                    break;
                }
                case 1: {
                    pointers = Collections.singletonList(this.pointers.get(0));
                    break;
                }
                default: {
                    pointers = Collections.unmodifiableList(new ArrayList<SubHeaderPointer>(this.pointers));
                }
            }
            switch (this.descriptorTypes == null ? 0 : this.descriptorTypes.size()) {
                case 0: {
                    descriptorTypes = Collections.emptyList();
                    break;
                }
                case 1: {
                    descriptorTypes = Collections.singletonList(this.descriptorTypes.get(0));
                    break;
                }
                default: {
                    descriptorTypes = Collections.unmodifiableList(new ArrayList<PValue<DescriptorType, String>>(this.descriptorTypes));
                }
            }
            return new SasFileStructure(this.header, pages, pointers, descriptorTypes);
        }

        public String toString() {
            return "SasFileStructure.Builder(header=" + this.header + ", pages=" + this.pages + ", pointers=" + this.pointers + ", descriptorTypes=" + this.descriptorTypes + ")";
        }
    }
}

