/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.assumptions;

import internal.ri.assumptions.SasFileAssumptionLoader;
import internal.ri.assumptions.SasFileError;
import internal.ri.assumptions.SasFileStructure;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface SasFileAssumption {
    public String getName();

    public String test(SeekableByteChannel var1, SasFileStructure var2) throws IOException;

    public static Stream<SasFileAssumption> getAll() {
        return SasFileAssumptionLoader.Provider.get().stream().flatMap(provider -> provider.getAssumptions().stream());
    }

    public static void testAll(Path file, Consumer<SasFileError> onError) throws IOException {
        try (SeekableByteChannel sbc = Files.newByteChannel(file, StandardOpenOption.READ);){
            SasFileStructure structure = SasFileStructure.of(sbc);
            Iterator iter = SasFileAssumption.getAll().iterator();
            while (iter.hasNext()) {
                SasFileAssumption assumption = (SasFileAssumption)iter.next();
                try {
                    String error = assumption.test(sbc, structure);
                    if (error == null) continue;
                    onError.accept(new SasFileError(file, assumption, error));
                }
                catch (IOException ex) {
                    onError.accept(new SasFileError(file, assumption, ex.getMessage()));
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            if (ex instanceof UncheckedIOException) {
                throw ((UncheckedIOException)ex).getCause();
            }
            throw new IOException(file.toString(), ex);
        }
    }

    public static interface Provider {
        public Collection<? extends SasFileAssumption> getAssumptions();
    }
}

