/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

import internal.bytes.BytesReader;
import internal.bytes.RecordLength;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.checkerframework.checker.index.qual.NonNegative;

public final class Seq {
    public static final Seq U4U8 = Seq.builder().and("int32/64", 4, 8).build();
    @NonNull
    private final List<Item> items;
    @NonNull
    private final RecordLength length32;
    @NonNull
    private final RecordLength length64;

    public static int parseU4U8(BytesReader bytes, int offset, boolean u64) {
        return u64 ? (int)bytes.getInt64(offset) : bytes.getInt32(offset);
    }

    private Seq(List<Item> items) {
        this.items = items;
        this.length32 = RecordLength.of(items.stream().mapToInt(Item::getLength32).toArray());
        this.length64 = RecordLength.of(items.stream().mapToInt(Item::getLength64).toArray());
    }

    private RecordLength get(boolean u64) {
        return u64 ? this.length64 : this.length32;
    }

    public int getOffset(boolean u64, int index) {
        return this.get(u64).getOffset(index);
    }

    public int getTotalLength(boolean u64) {
        return this.get(u64).getTotalLength();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public List<Item> getItems() {
        return this.items;
    }

    public static final class Item {
        @NonNull
        private final String name;
        private final @NonNegative int length32;
        private final @NonNegative int length64;

        public Item(@NonNull String name, @NonNegative int length32, @NonNegative int length64) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.length32 = length32;
            this.length64 = length64;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public @NonNegative int getLength32() {
            return this.length32;
        }

        public @NonNegative int getLength64() {
            return this.length64;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (this.getLength32() != other.getLength32()) {
                return false;
            }
            if (this.getLength64() != other.getLength64()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength32();
            result = result * 59 + this.getLength64();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Seq.Item(name=" + this.getName() + ", length32=" + this.getLength32() + ", length64=" + this.getLength64() + ")";
        }
    }

    public static final class Builder {
        private final List<Item> items = new ArrayList<Item>();

        private Builder item(Item item) {
            this.items.add(item);
            return this;
        }

        public Builder and(String name, int length) {
            return this.item(new Item(name, length, length));
        }

        public Builder and(String name, int length32, int length64) {
            return this.item(new Item(name, length32, length64));
        }

        public Builder and(String name, Seq seq) {
            return this.item(new Item(name, seq.get(false).getTotalLength(), seq.get(true).getTotalLength()));
        }

        public Builder and(Seq seq) {
            return this.item(new Item("", seq.get(false).getTotalLength(), seq.get(true).getTotalLength()));
        }

        public Seq build() {
            switch (this.items.size()) {
                case 0: {
                    return new Seq(Collections.emptyList());
                }
                case 1: {
                    return new Seq(Collections.singletonList(this.items.get(0)));
                }
            }
            return new Seq(Collections.unmodifiableList(new ArrayList<Item>(this.items)));
        }
    }
}

