/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

public final class RecordLength {
    private final int[] lengths;
    private final int[] offsets;
    private final int totalLength;

    public static RecordLength of(int ... lengths) {
        int[] offsets = new int[lengths.length];
        System.arraycopy(lengths, 0, offsets, 1, offsets.length - 1);
        int totalLength = lengths[0];
        for (int i = 1; i < offsets.length; ++i) {
            totalLength += lengths[i];
            int n = i;
            offsets[n] = offsets[n] + offsets[i - 1];
        }
        return new RecordLength(lengths, offsets, totalLength);
    }

    public int getLength(int index) {
        return this.lengths[index];
    }

    public int getOffset(int index) {
        return this.offsets[index];
    }

    public RecordLength and(int ... lengths) {
        return this.and(RecordLength.of(lengths));
    }

    public RecordLength and(RecordLength that) {
        int[] newLengths = new int[this.lengths.length + that.lengths.length];
        System.arraycopy(this.lengths, 0, newLengths, 0, this.lengths.length);
        System.arraycopy(that.lengths, 0, newLengths, this.lengths.length, that.lengths.length);
        return RecordLength.of(newLengths);
    }

    private RecordLength(int[] lengths, int[] offsets, int totalLength) {
        this.lengths = lengths;
        this.offsets = offsets;
        this.totalLength = totalLength;
    }

    public int getTotalLength() {
        return this.totalLength;
    }
}

