/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Record {
    public static <X> List<X> toList(int count, int offset, int length, IntFunction<X> factory) {
        return Record.toList(count, offset, length, (int i, int base) -> factory.apply(base));
    }

    public static <X> List<X> toList(int count, int offset, int length, BiIntFunction<X> factory) {
        return IntStream.range(0, count).mapToObj(i -> factory.apply(i, Record.getBase(offset, length, i))).collect(Collectors.toList());
    }

    public static int getBase(int offset, int length, int index) {
        return offset + length * index;
    }

    private Record() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface BiIntFunction<X> {
        public X apply(int var1, int var2);
    }
}

