/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PValue<V, R> {
    @lombok.NonNull
    private final Object obj;
    private final boolean known;

    public static <V, R> @NonNull PValue<V, R> known(@NonNull V value) {
        return new PValue<V, R>(value, true);
    }

    public static <V, R> @NonNull PValue<V, R> unknown(@NonNull R raw) {
        return new PValue<V, R>(raw, false);
    }

    public boolean isKnown() {
        return this.known;
    }

    public boolean isKnownAs(@NonNull V value) {
        return this.known && value.equals(this.obj);
    }

    public boolean isUnknown() {
        return !this.known;
    }

    public @NonNull V get() throws IllegalStateException {
        if (!this.known) {
            throw new IllegalStateException();
        }
        return (V)this.obj;
    }

    public @NonNull R getRaw() throws IllegalStateException {
        if (this.known) {
            throw new IllegalStateException();
        }
        return (R)this.obj;
    }

    public @NonNull V or(@NonNull V defaultValue) {
        return (V)(this.known ? this.obj : Objects.requireNonNull(defaultValue));
    }

    public <X extends Throwable> @NonNull V orElseThrow(@NonNull Function<? super R, ? extends X> exceptionSupplier) throws X {
        Objects.requireNonNull(exceptionSupplier);
        if (this.known) {
            return (V)this.obj;
        }
        throw (Throwable)exceptionSupplier.apply(this.obj);
    }

    public String toString() {
        return this.known ? this.obj.toString() : "=(" + this.obj + ")=";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PValue)) {
            return false;
        }
        PValue other = (PValue)o;
        if (this.isKnown() != other.isKnown()) {
            return false;
        }
        Object this$obj = this.obj;
        Object other$obj = other.obj;
        return !(this$obj == null ? other$obj != null : !this$obj.equals(other$obj));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKnown() ? 79 : 97);
        Object $obj = this.obj;
        result = result * 59 + ($obj == null ? 43 : $obj.hashCode());
        return result;
    }

    private PValue(@lombok.NonNull Object obj, boolean known) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        this.obj = obj;
        this.known = known;
    }
}

