/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

import internal.bytes.BytesReader;
import internal.bytes.BytesWriter;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public final class BytesWithOffset
implements BytesReader {
    private BytesReader delegate = null;
    private int offset = 0;

    public void reset(BytesReader delegate, int offset) {
        this.delegate = delegate;
        this.offset = offset;
    }

    public void incrementOffset(int length) {
        this.offset += length;
    }

    @Override
    public byte getByte(int index) {
        return this.delegate.getByte(this.offset + index);
    }

    @Override
    public byte[] getBytes(int index, int length) {
        return this.delegate.getBytes(this.offset + index, length);
    }

    @Override
    public double getFloat64(int index) {
        return this.delegate.getFloat64(this.offset + index);
    }

    @Override
    public float getFloat32(int index) {
        return this.delegate.getFloat32(this.offset + index);
    }

    @Override
    public int getInt32(int index) {
        return this.delegate.getInt32(this.offset + index);
    }

    @Override
    public int getLength() {
        return this.delegate.getLength() - this.offset;
    }

    @Override
    public long getInt64(int index) {
        return this.delegate.getInt64(this.offset + index);
    }

    @Override
    public short getInt16(int index) {
        return this.delegate.getInt16(this.offset + index);
    }

    @Override
    public String getString(int index, int length, Charset charset) {
        return this.delegate.getString(this.offset + index, length, charset);
    }

    @Override
    public short getUInt8(int index) {
        return this.delegate.getUInt8(this.offset + index);
    }

    @Override
    public int getUInt16(int index) {
        return this.delegate.getUInt16(this.offset + index);
    }

    @Override
    public void copyTo(int index, byte[] dst, int dstPos, int length) {
        this.delegate.copyTo(this.offset + index, dst, dstPos, length);
    }

    @Override
    public void copyTo(int index, BytesWriter dst, int dstPos, int length) {
        this.delegate.copyTo(this.offset + index, dst, dstPos, length);
    }

    @Override
    public BytesReader slice(int index, int length) {
        return this.delegate.slice(this.offset + index, length);
    }

    @Override
    public CharBuffer decode(int index, int length, CharsetDecoder decoder) throws CharacterCodingException {
        return this.delegate.decode(this.offset + index, length, decoder);
    }

    @Override
    public ByteOrder getOrder() {
        return this.delegate.getOrder();
    }

    @Override
    public BytesReader duplicate(ByteOrder order) {
        BytesWithOffset result = new BytesWithOffset();
        result.reset(this.delegate.duplicate(order), this.offset);
        return result;
    }
}

