/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

import internal.bytes.BytesWriter;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface BytesReader {
    public int getLength();

    public byte getByte(int var1);

    default public byte getLow(int index) {
        return (byte)(this.getByte(index) & 0xF);
    }

    default public byte getHigh(int index) {
        return (byte)(this.getByte(index) >> 4 & 0xF);
    }

    public @NonNull byte[] getBytes(int var1, int var2);

    public float getFloat32(int var1);

    public double getFloat64(int var1);

    public short getInt16(int var1);

    public int getInt32(int var1);

    public long getInt64(int var1);

    default public short getUInt8(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    default public int getUInt16(int index) {
        return this.getInt16(index) & 0xFFFF;
    }

    public @NonNull String getString(int var1, int var2, @NonNull Charset var3);

    default public @NonNull byte[] toArray() {
        byte[] result = new byte[this.getLength()];
        this.copyTo(0, result, 0, result.length);
        return result;
    }

    public void copyTo(int var1, @NonNull byte[] var2, int var3, int var4);

    default public void copyTo(int index, @NonNull BytesWriter dst, int dstPos, int length) {
        for (int i = 0; i < length; ++i) {
            dst.putByte(dstPos + i, this.getByte(index + i));
        }
    }

    public @NonNull BytesReader slice(int var1, int var2);

    public @NonNull CharBuffer decode(int var1, int var2, @NonNull CharsetDecoder var3) throws CharacterCodingException;

    public @NonNull ByteOrder getOrder();

    public @NonNull BytesReader duplicate(@NonNull ByteOrder var1);
}

