/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import lombok.NonNull;
import org.checkerframework.checker.index.qual.NonNegative;

public final class BytesPrinter {
    private @NonNegative int index;
    private @NonNegative int length;
    @NonNull
    private int[] groupSizes;
    @NonNull
    private final PrintStream stream;

    public BytesPrinter print(Path file) throws IOException {
        Bytes bytes = Bytes.allocate(this.length, ByteOrder.nativeOrder());
        try (SeekableByteChannel sbc = Files.newByteChannel(file, StandardOpenOption.READ);){
            bytes.fill(sbc, this.index);
        }
        return this.print(bytes);
    }

    public BytesPrinter print(BytesReader bytes) {
        int[] stackSizes = (int[])this.groupSizes.clone();
        for (int i = 1; i < stackSizes.length; ++i) {
            int n = i;
            stackSizes[n] = stackSizes[n] + stackSizes[i - 1];
        }
        int groupIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            this.stream.print(String.format("%02X ", bytes.getByte(this.index + i)));
            int groupSize = stackSizes[groupIndex % this.groupSizes.length];
            if (i % groupSize != groupSize - 1) continue;
            if (groupIndex % this.groupSizes.length == this.groupSizes.length - 1) {
                this.stream.println("");
            } else {
                this.stream.print("| ");
            }
            ++groupIndex;
        }
        this.stream.println();
        return this;
    }

    BytesPrinter(@NonNegative int index, @NonNegative int length, @NonNull int[] groupSizes, @NonNull PrintStream stream) {
        if (groupSizes == null) {
            throw new NullPointerException("groupSizes is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        this.index = index;
        this.length = length;
        this.groupSizes = groupSizes;
        this.stream = stream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int index;
        private int length;
        private int[] groupSizes;
        private PrintStream stream;

        Builder() {
        }

        public Builder index(@NonNegative int index) {
            this.index = index;
            return this;
        }

        public Builder length(@NonNegative int length) {
            this.length = length;
            return this;
        }

        public Builder groupSizes(@NonNull int[] groupSizes) {
            if (groupSizes == null) {
                throw new NullPointerException("groupSizes is marked non-null but is null");
            }
            this.groupSizes = groupSizes;
            return this;
        }

        public Builder stream(@NonNull PrintStream stream) {
            if (stream == null) {
                throw new NullPointerException("stream is marked non-null but is null");
            }
            this.stream = stream;
            return this;
        }

        public BytesPrinter build() {
            return new BytesPrinter(this.index, this.length, this.groupSizes, this.stream);
        }

        public String toString() {
            return "BytesPrinter.Builder(index=" + this.index + ", length=" + this.length + ", groupSizes=" + Arrays.toString(this.groupSizes) + ", stream=" + this.stream + ")";
        }
    }
}

