/*
 * Decompiled with CFR 0.152.
 */
package internal.bytes;

import internal.bytes.BytesReader;
import internal.bytes.BytesWriter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Bytes
implements BytesReader,
BytesWriter {
    @lombok.NonNull
    private final ByteBuffer internal;
    public static final int SHORT_OFFSET = 2;
    public static final int INT_OFFSET = 4;
    public static final int LONG_OFFSET = 8;

    public static @NonNull Bytes allocate(int capacity, @NonNull ByteOrder order) {
        return new Bytes(ByteBuffer.allocate(capacity).order(order));
    }

    public static @NonNull Bytes wrap(@NonNull byte[] bytes, @NonNull ByteOrder order) {
        return new Bytes(ByteBuffer.wrap(bytes).order(order));
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Bytes && this.equals((Bytes)obj);
    }

    private boolean equals(Bytes that) {
        return this.internal.equals(that.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    @Override
    public int getLength() {
        return this.internal.capacity();
    }

    @Override
    public byte getByte(int index) {
        return this.internal.get(index);
    }

    @Override
    public short getInt16(int index) {
        return this.internal.getShort(index);
    }

    @Override
    public int getInt32(int index) {
        return this.internal.getInt(index);
    }

    @Override
    public long getInt64(int index) {
        return this.internal.getLong(index);
    }

    @Override
    public float getFloat32(int index) {
        return this.internal.getFloat(index);
    }

    @Override
    public double getFloat64(int index) {
        return this.internal.getDouble(index);
    }

    @Override
    public ByteOrder getOrder() {
        return this.internal.order();
    }

    @Override
    public BytesReader slice(int index, int length) {
        Bytes.fixJava9(this.internal).position(index);
        Bytes.fixJava9(this.internal).limit(index + length);
        ByteBuffer result = this.internal.slice().order(this.internal.order());
        Bytes.fixJava9(this.internal).clear();
        return new Bytes(result);
    }

    @Override
    public String getString(int index, int length, Charset charset) {
        return length > 0 ? new String(this.getBytes(index, length), charset).trim() : "";
    }

    @Override
    public void copyTo(int index, byte[] dst, int dstPos, int length) {
        Bytes.fixJava9(this.internal).position(index);
        this.internal.get(dst, dstPos, length);
        Bytes.fixJava9(this.internal).position(0);
    }

    @Override
    public byte[] getBytes(int index, int length) {
        byte[] result = new byte[length];
        this.copyTo(index, result, 0, length);
        return result;
    }

    @Override
    public CharBuffer decode(int index, int length, CharsetDecoder decoder) throws CharacterCodingException {
        Bytes.fixJava9(this.internal).position(index);
        Bytes.fixJava9(this.internal).limit(index + length);
        CharBuffer result = decoder.decode(this.internal);
        Bytes.fixJava9(this.internal).clear();
        return result;
    }

    @Override
    public BytesReader duplicate(ByteOrder order) {
        return new Bytes(this.internal.duplicate().order(order));
    }

    @Override
    public void fill(SeekableByteChannel sbc, long position) throws IOException {
        Bytes.fixJava9(this.internal).clear();
        sbc.position(position);
        sbc.read(this.internal);
        Bytes.fixJava9(this.internal).clear();
    }

    @Override
    public void putByte(int index, byte b) {
        this.internal.put(index, b);
    }

    private static Buffer fixJava9(ByteBuffer buffer) {
        return buffer;
    }

    private Bytes(@lombok.NonNull ByteBuffer internal) {
        if (internal == null) {
            throw new NullPointerException("internal is marked non-null but is null");
        }
        this.internal = internal;
    }
}

