package internal.ri.assumptions;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class SasFileAssumptionLoader {
  /**
   * Custom service loader for {@link internal.ri.assumptions.SasFileAssumption.Provider}.
   * <br>This class is thread-safe.
   * <p>Properties:
   * <ul>
   * <li>Quantifier: MULTIPLE</li>
   * <li>Fallback: null</li>
   * <li>Preprocessing: null</li>
   * <li>Mutability: NONE</li>
   * <li>Singleton: true</li>
   * <li>Name: null</li>
   * </ul>
   */
  public static final class Provider {
    private static final ServiceLoader<SasFileAssumption.Provider> SOURCE = ServiceLoader.load(SasFileAssumption.Provider.class);

    private static final List<SasFileAssumption.Provider> RESOURCE = doLoad();

    private Provider() {
    }

    private static List<SasFileAssumption.Provider> doLoad() {
      return StreamSupport.stream(SOURCE.spliterator(), false)
          .collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    /**
     * Gets a list of {@link internal.ri.assumptions.SasFileAssumption.Provider} instances.
     * <br>This method is thread-safe.
     * @return the current non-null value
     */
    public static List<SasFileAssumption.Provider> get() {
      return RESOURCE;
    }
  }
}
