/*
 * Decompiled with CFR 0.152.
 */
package sasquatch.parso;

import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import sasquatch.SasForwardCursor;
import sasquatch.SasMetaData;
import sasquatch.SasScrollableCursor;
import sasquatch.SasSplittableCursor;
import sasquatch.parso.ParsoCursor;
import sasquatch.spi.SasFeature;
import sasquatch.spi.SasReader;
import sasquatch.util.SasCursors;

public final class ParsoReader
implements SasReader {
    public String getName() {
        return "Parso";
    }

    public boolean isAvailable() {
        return true;
    }

    public int getCost() {
        return 100;
    }

    public Set<SasFeature> getFeatures() {
        return EnumSet.of(SasFeature.ATTRIBUTES, new SasFeature[]{SasFeature.LABEL_META, SasFeature.BIG_ENDIAN_32, SasFeature.LITTLE_ENDIAN_32, SasFeature.BIG_ENDIAN_64, SasFeature.LITTLE_ENDIAN_64, SasFeature.CHAR_COMP, SasFeature.BIN_COMP, SasFeature.DATE_TYPE, SasFeature.DATE_TIME_TYPE, SasFeature.TIME_TYPE, SasFeature.FIELD_ENCODING, SasFeature.COLUMN_ENCODING, SasFeature.CUSTOM_NUMERIC, SasFeature.COLUMN_FORMAT});
    }

    public SasForwardCursor readForward(Path file) throws IOException {
        return new ParsoCursor(file);
    }

    public SasScrollableCursor readScrollable(Path file) throws IOException {
        return SasCursors.asScrollable((SasForwardCursor)this.readForward(file));
    }

    public SasSplittableCursor readSplittable(Path file) throws IOException {
        return SasCursors.asSplittable((SasForwardCursor)this.readForward(file));
    }

    public SasMetaData readMetaData(Path file) throws IOException {
        try (SasForwardCursor cursor = this.readForward(file);){
            SasMetaData sasMetaData = cursor.getMetaData();
            return sasMetaData;
        }
    }
}

