/*
 * Decompiled with CFR 0.152.
 */
package sasquatch.parso;

import com.epam.parso.Column;
import com.epam.parso.ColumnFormat;
import com.epam.parso.SasFileProperties;
import com.epam.parso.SasFileReader;
import com.epam.parso.impl.ColumnUtil;
import com.epam.parso.impl.SasFileReaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import sasquatch.SasColumn;
import sasquatch.SasColumnFormat;
import sasquatch.SasForwardCursor;
import sasquatch.SasMetaData;

final class ParsoCursor
implements SasForwardCursor {
    private final InputStream stream;
    private final SasFileReader reader;
    private final SasMetaData metaData;
    private Object[] currentRow;

    public ParsoCursor(Path file) throws IOException {
        this.stream = Files.newInputStream(file, new OpenOption[0]);
        this.reader = new SasFileReaderImpl(this.stream);
        this.metaData = ParsoCursor.getMetaData(this.reader);
        this.currentRow = null;
    }

    public SasMetaData getMetaData() throws IOException {
        return this.metaData;
    }

    public boolean next() throws IOException {
        this.currentRow = this.reader.readNext();
        return this.currentRow != null;
    }

    public Object getValue(int columnIndex) throws IOException, IndexOutOfBoundsException {
        switch (((SasColumn)this.getColumns().get(columnIndex)).getType()) {
            case CHARACTER: {
                return this.currentRow[columnIndex];
            }
            case NUMERIC: {
                return this.currentRow[columnIndex];
            }
            case DATE: {
                return this.getDate(columnIndex);
            }
            case DATETIME: {
                return this.getDateTime(columnIndex);
            }
            case TIME: {
                return this.getTime(columnIndex);
            }
        }
        throw new RuntimeException("Invalid type");
    }

    public double getNumber(int columnIndex) throws IOException, IndexOutOfBoundsException, IllegalArgumentException {
        try {
            Number number = (Number)this.currentRow[columnIndex];
            return number != null ? number.doubleValue() : Double.NaN;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getString(int columnIndex) throws IOException, IndexOutOfBoundsException, IllegalArgumentException {
        try {
            return (String)this.currentRow[columnIndex];
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public LocalDate getDate(int columnIndex) throws IOException, IndexOutOfBoundsException, IllegalArgumentException {
        try {
            Date date = (Date)this.currentRow[columnIndex];
            return date != null ? ParsoCursor.toLocalDateTime(date).toLocalDate() : null;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public LocalDateTime getDateTime(int columnIndex) throws IOException, IndexOutOfBoundsException, IllegalArgumentException {
        try {
            Date date = (Date)this.currentRow[columnIndex];
            return date != null ? ParsoCursor.toLocalDateTime(date) : null;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public LocalTime getTime(int columnIndex) throws IOException, IndexOutOfBoundsException, IllegalArgumentException {
        try {
            Number number = (Number)this.currentRow[columnIndex];
            return number != null ? ParsoCursor.toLocalTime(number) : null;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Object[] getValues() throws IOException {
        Object[] result = new Object[this.currentRow.length];
        for (int j = 0; j < result.length; ++j) {
            result[j] = this.getValue(j);
        }
        return result;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    private static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
    }

    private static LocalTime toLocalTime(Number number) {
        return LocalTime.MIDNIGHT.plusSeconds(number.longValue());
    }

    private static SasMetaData getMetaData(SasFileReader reader) throws IOException {
        SasFileProperties p = reader.getSasFileProperties();
        return SasMetaData.builder().name(p.getName()).label(p.getFileLabel()).creationTime(ParsoCursor.toLocalDateTime(p.getDateCreated())).lastModificationTime(ParsoCursor.toLocalDateTime(p.getDateModified())).release(p.getSasRelease()).host(p.getServerType()).rowCount((int)p.getRowCount()).columns(ParsoCursor.getColumns(reader.getColumns())).build();
    }

    private static List<SasColumn> getColumns(List<Column> columns) {
        SasColumn.Builder b = SasColumn.builder();
        return columns.stream().map(o -> b.order(o.getId() - 1).name(o.getName()).type(ColumnUtil.getType(o.getType(), o.getFormat().getName())).length(o.getLength()).format(ParsoCursor.getFormat(o.getFormat())).label(o.getLabel()).build()).collect(Collectors.toList());
    }

    private static SasColumnFormat getFormat(ColumnFormat o) {
        return SasColumnFormat.builder().name(o.getName()).width(o.getWidth()).precision(o.getPrecision()).build();
    }
}

