/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.odbc.win;

import internal.sql.odbc.win.WinOdbcRegistryUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.sys.OS;
import nbbrd.io.win.RegWrapper;
import nbbrd.io.win.WhereWrapper;
import nbbrd.sql.odbc.OdbcDataSource;
import nbbrd.sql.odbc.OdbcDriver;
import nbbrd.sql.odbc.OdbcRegistrySpi;

public final class RegOdbcRegistry
implements OdbcRegistrySpi {
    @Generated
    private static final Logger log = Logger.getLogger(RegOdbcRegistry.class.getName());

    @Override
    @NonNull
    public String getName() {
        return "OdbcRegistryOverRegCommand";
    }

    @Override
    public boolean isAvailable() {
        return OS.NAME == OS.Name.WINDOWS && RegOdbcRegistry.isCommandAvailable();
    }

    @Override
    public int getCost() {
        return 1000;
    }

    @Override
    @NonNull
    public List<String> getDataSourceNames(OdbcDataSource.Type[] types) throws IOException {
        MapRegistry.Builder reg = MapRegistry.builder();
        for (OdbcDataSource.Type o : types) {
            reg.load(WinOdbcRegistryUtil.getRoot(o), "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources", false);
        }
        return WinOdbcRegistryUtil.getDataSourceNames(reg.build(), types);
    }

    @Override
    @NonNull
    public List<OdbcDataSource> getDataSources(OdbcDataSource.Type[] types) throws IOException {
        MapRegistry.Builder reg = MapRegistry.builder();
        for (OdbcDataSource.Type o : types) {
            reg.load(WinOdbcRegistryUtil.getRoot(o), "SOFTWARE\\ODBC\\ODBC.INI", true);
        }
        return WinOdbcRegistryUtil.getDataSources(reg.build(), types);
    }

    @Override
    @NonNull
    public List<String> getDriverNames() throws IOException {
        MapRegistry reg = MapRegistry.builder().load(WinOdbcRegistryUtil.Registry.Root.HKEY_LOCAL_MACHINE, "SOFTWARE\\ODBC\\Odbcinst.INI\\ODBC Drivers", false).build();
        return WinOdbcRegistryUtil.getDriverNames(reg);
    }

    @Override
    @NonNull
    public List<OdbcDriver> getDrivers() throws IOException {
        MapRegistry reg = MapRegistry.builder().load(WinOdbcRegistryUtil.Registry.Root.HKEY_LOCAL_MACHINE, "SOFTWARE\\ODBC\\Odbcinst.INI", true).build();
        return WinOdbcRegistryUtil.getDrivers(reg);
    }

    private static boolean isCommandAvailable() {
        try {
            return WhereWrapper.isAvailable((String)"reg");
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "While checking command availability", ex);
            return false;
        }
    }

    private static final class MapRegistry
    implements WinOdbcRegistryUtil.Registry {
        private final Map<String, List<RegWrapper.RegValue>> keys;

        @Override
        public boolean keyExists(@NonNull WinOdbcRegistryUtil.Registry.Root root, @NonNull String key) {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            String target = (Object)((Object)root) + "\\" + key;
            return this.keys.keySet().stream().anyMatch(o -> o.startsWith(target));
        }

        @Override
        @NonNull
        public Map<String, Object> getValues(@NonNull WinOdbcRegistryUtil.Registry.Root root, @NonNull String key) {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            String target = (Object)((Object)root) + "\\" + key;
            return this.keys.containsKey(target) ? this.keys.get(target).stream().collect(Collectors.toMap(RegWrapper.RegValue::getName, RegWrapper.RegValue::getValue)) : Collections.emptySortedMap();
        }

        @Generated
        MapRegistry(Map<String, List<RegWrapper.RegValue>> keys) {
            this.keys = keys;
        }

        @Generated
        public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
            return new Builder();
        }

        public static class Builder {
            @Generated
            private ArrayList<String> keys$key;
            @Generated
            private ArrayList<List<RegWrapper.RegValue>> keys$value;

            public Builder load(WinOdbcRegistryUtil.Registry.Root root, String subkey, boolean recursive) throws IOException {
                String keyName = (Object)((Object)root) + "\\" + subkey;
                try {
                    return this.keys(RegWrapper.query((String)keyName, (boolean)recursive));
                }
                catch (IOException ex) {
                    if (ex.getMessage().contains("Invalid exit value: 1")) {
                        return this;
                    }
                    throw ex;
                }
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder key(String keyKey, List<RegWrapper.RegValue> keyValue) {
                if (this.keys$key == null) {
                    this.keys$key = new ArrayList();
                    this.keys$value = new ArrayList();
                }
                this.keys$key.add(keyKey);
                this.keys$value.add(keyValue);
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder keys(@org.checkerframework.checker.nullness.qual.NonNull Map<? extends String, ? extends List<// Could not load outer class - annotation placement on inner may be incorrect
            RegWrapper.RegValue>> keys) {
                if (keys == null) {
                    throw new NullPointerException("keys cannot be null");
                }
                if (this.keys$key == null) {
                    this.keys$key = new ArrayList();
                    this.keys$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends List<RegWrapper.RegValue>> $lombokEntry : keys.entrySet()) {
                    this.keys$key.add($lombokEntry.getKey());
                    this.keys$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder clearKeys() {
                if (this.keys$key != null) {
                    this.keys$key.clear();
                    this.keys$value.clear();
                }
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull MapRegistry build() {
                Map<String, List<RegWrapper.RegValue>> keys;
                switch (this.keys$key == null ? 0 : this.keys$key.size()) {
                    case 0: {
                        keys = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        keys = Collections.singletonMap(this.keys$key.get(0), this.keys$value.get(0));
                        break;
                    }
                    default: {
                        keys = new LinkedHashMap<String, List<RegWrapper.RegValue>>(this.keys$key.size() < 0x40000000 ? 1 + this.keys$key.size() + (this.keys$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.keys$key.size(); ++$i) {
                            keys.put(this.keys$key.get($i), this.keys$value.get($i));
                        }
                        keys = Collections.unmodifiableMap(keys);
                    }
                }
                return new MapRegistry(keys);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "RegOdbcRegistry.MapRegistry.Builder(keys$key=" + this.keys$key + ", keys$value=" + this.keys$value + ")";
            }
        }
    }
}

