/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.odbc.win;

import java.sql.Connection;
import java.sql.SQLException;
import lombok.NonNull;
import nbbrd.sql.jdbc.SqlConnectionSupplier;
import nbbrd.sql.odbc.OdbcConnectionSupplierSpi;

public final class SunOdbcConnectionSupplier
implements OdbcConnectionSupplierSpi {
    private static final String JDBC_ODBC_DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static final String JDBC_ODBC_DRIVER_PREFIX = "jdbc:odbc:";
    private final SqlConnectionSupplier delegate = SqlConnectionSupplier.ofDriverManager((String)"sun.jdbc.odbc.JdbcOdbcDriver", o -> JDBC_ODBC_DRIVER_PREFIX + o);

    @Override
    @NonNull
    public String getName() {
        return JDBC_ODBC_DRIVER_NAME;
    }

    @Override
    public boolean isAvailable() {
        return !SunOdbcConnectionSupplier.is64bit() && SqlConnectionSupplier.isDriverLoadable((String)JDBC_ODBC_DRIVER_NAME) && SqlConnectionSupplier.isDriverRegistered((String)JDBC_ODBC_DRIVER_NAME);
    }

    @Override
    public int getCost() {
        return 100;
    }

    @Override
    @NonNull
    public Connection getConnection(@NonNull String connectionString) throws SQLException {
        if (connectionString == null) {
            throw new NullPointerException("connectionString is marked non-null but is null");
        }
        return this.delegate.getConnection(connectionString);
    }

    private static boolean is64bit() {
        return "amd64".equals(System.getProperty("os.arch"));
    }
}

