/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.odbc;

import internal.sql.odbc.FailsafeOdbcConnectionSupplier;
import internal.sql.odbc.OdbcConnectionSupplierSpiLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import nbbrd.sql.jdbc.SqlConnectionSupplier;
import nbbrd.sql.odbc.OdbcConnectionString;
import nbbrd.sql.odbc.OdbcConnectionSupplierSpi;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class OdbcConnectionSupplier
implements SqlConnectionSupplier {
    @lombok.NonNull
    private final OdbcConnectionSupplierSpi spi;

    public static @NonNull Optional<OdbcConnectionSupplier> ofServiceLoader() {
        return OdbcConnectionSupplierSpiLoader.load().map(FailsafeOdbcConnectionSupplier::wrap).map(OdbcConnectionSupplier::new);
    }

    public @NonNull String getName() {
        return this.spi.getName();
    }

    public Connection getConnection(String connectionString) throws SQLException {
        return this.spi.getConnection(connectionString);
    }

    public @NonNull Connection getConnection(@NonNull OdbcConnectionString connectionString) throws SQLException {
        return this.spi.getConnection(connectionString.toString());
    }

    @Generated
    private OdbcConnectionSupplier(@lombok.NonNull OdbcConnectionSupplierSpi spi) {
        if (spi == null) {
            throw new NullPointerException("spi is marked non-null but is null");
        }
        this.spi = spi;
    }

    @Generated
    public static @NonNull OdbcConnectionSupplier of(@lombok.NonNull OdbcConnectionSupplierSpi spi) {
        return new OdbcConnectionSupplier(spi);
    }
}

