/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.odbc;

import java.io.File;
import lombok.NonNull;

public final class OdbcDataSource {
    @NonNull
    private final Type type;
    @NonNull
    private final String name;
    private final String description;
    @NonNull
    private final String driverName;
    @NonNull
    private final File driverPath;
    private final String serverName;

    OdbcDataSource(@NonNull Type type, @NonNull String name, String description, @NonNull String driverName, @NonNull File driverPath, String serverName) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (driverName == null) {
            throw new NullPointerException("driverName is marked non-null but is null");
        }
        if (driverPath == null) {
            throw new NullPointerException("driverPath is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
        this.description = description;
        this.driverName = driverName;
        this.driverPath = driverPath;
        this.serverName = serverName;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getDriverName() {
        return this.driverName;
    }

    @NonNull
    public File getDriverPath() {
        return this.driverPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OdbcDataSource)) {
            return false;
        }
        OdbcDataSource other = (OdbcDataSource)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        File this$driverPath = this.getDriverPath();
        File other$driverPath = other.getDriverPath();
        if (this$driverPath == null ? other$driverPath != null : !((Object)this$driverPath).equals(other$driverPath)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        return !(this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        File $driverPath = this.getDriverPath();
        result = result * 59 + ($driverPath == null ? 43 : ((Object)$driverPath).hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        return result;
    }

    public String toString() {
        return "OdbcDataSource(type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", driverName=" + this.getDriverName() + ", driverPath=" + this.getDriverPath() + ", serverName=" + this.getServerName() + ")";
    }

    public static class Builder {
        private Type type;
        private String name;
        private String description;
        private String driverName;
        private File driverPath;
        private String serverName;

        Builder() {
        }

        public Builder type(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder driverName(@NonNull String driverName) {
            if (driverName == null) {
                throw new NullPointerException("driverName is marked non-null but is null");
            }
            this.driverName = driverName;
            return this;
        }

        public Builder driverPath(@NonNull File driverPath) {
            if (driverPath == null) {
                throw new NullPointerException("driverPath is marked non-null but is null");
            }
            this.driverPath = driverPath;
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public OdbcDataSource build() {
            return new OdbcDataSource(this.type, this.name, this.description, this.driverName, this.driverPath, this.serverName);
        }

        public String toString() {
            return "OdbcDataSource.Builder(type=" + (Object)((Object)this.type) + ", name=" + this.name + ", description=" + this.description + ", driverName=" + this.driverName + ", driverPath=" + this.driverPath + ", serverName=" + this.serverName + ")";
        }
    }

    public static enum Type {
        SYSTEM,
        USER,
        FILE;

    }
}

