/*
 * Decompiled with CFR 0.152.
 */
package internal.sys;

import internal.sys.ResourceExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import lombok.NonNull;

public final class DefaultResourceExtractor
implements ResourceExtractor {
    @NonNull
    private final File repository;
    private final boolean persist;
    @NonNull
    private final Class<?> anchor;

    @Override
    public File getResourceAsFile(String resourceName) throws IOException {
        try (InputStream stream = this.anchor.getResourceAsStream(resourceName);){
            if (stream == null) {
                throw new FileNotFoundException(resourceName);
            }
            File result = DefaultResourceExtractor.createEmptyFile(this.repository, resourceName);
            Files.copy(stream, result.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!this.persist) {
                result.deleteOnExit();
            }
            File file = result;
            return file;
        }
    }

    public static Builder builder() {
        return new Builder().repository(DefaultResourceExtractor.getTempFolder()).persist(false);
    }

    public static DefaultResourceExtractor of(Class<?> anchor) {
        return DefaultResourceExtractor.builder().anchor(anchor).build();
    }

    private static File getTempFolder() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private static File createEmptyFile(File parent, String resourceName) throws IOException {
        int idx = resourceName.lastIndexOf(".");
        return idx != -1 ? File.createTempFile(resourceName.substring(0, idx), resourceName.substring(idx), parent) : File.createTempFile("rsrc", resourceName, parent);
    }

    DefaultResourceExtractor(@NonNull File repository, boolean persist, @NonNull Class<?> anchor) {
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        this.repository = repository;
        this.persist = persist;
        this.anchor = anchor;
    }

    @NonNull
    public File getRepository() {
        return this.repository;
    }

    public boolean isPersist() {
        return this.persist;
    }

    @NonNull
    public Class<?> getAnchor() {
        return this.anchor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultResourceExtractor)) {
            return false;
        }
        DefaultResourceExtractor other = (DefaultResourceExtractor)o;
        if (this.isPersist() != other.isPersist()) {
            return false;
        }
        File this$repository = this.getRepository();
        File other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        Class<?> this$anchor = this.getAnchor();
        Class<?> other$anchor = other.getAnchor();
        return !(this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPersist() ? 79 : 97);
        File $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        Class<?> $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultResourceExtractor(repository=" + this.getRepository() + ", persist=" + this.isPersist() + ", anchor=" + this.getAnchor() + ")";
    }

    public static class Builder {
        private File repository;
        private boolean persist;
        private Class<?> anchor;

        Builder() {
        }

        public Builder repository(@NonNull File repository) {
            if (repository == null) {
                throw new NullPointerException("repository is marked non-null but is null");
            }
            this.repository = repository;
            return this;
        }

        public Builder persist(boolean persist) {
            this.persist = persist;
            return this;
        }

        public Builder anchor(@NonNull Class<?> anchor) {
            if (anchor == null) {
                throw new NullPointerException("anchor is marked non-null but is null");
            }
            this.anchor = anchor;
            return this;
        }

        public DefaultResourceExtractor build() {
            return new DefaultResourceExtractor(this.repository, this.persist, this.anchor);
        }

        public String toString() {
            return "DefaultResourceExtractor.Builder(repository=" + this.repository + ", persist=" + this.persist + ", anchor=" + this.anchor + ")";
        }
    }
}

