/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.odbc;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import nbbrd.sql.odbc.OdbcDataSource;
import nbbrd.sql.odbc.OdbcDriver;
import nbbrd.sql.odbc.OdbcRegistrySpi;

public final class FailsafeOdbcRegistry
implements OdbcRegistrySpi {
    private static final Logger log = Logger.getLogger(FailsafeOdbcRegistry.class.getName());
    @NonNull
    private final OdbcRegistrySpi delegate;
    @NonNull
    private final BiConsumer<? super String, ? super RuntimeException> onUnexpectedError;
    @NonNull
    private final Consumer<? super String> onUnexpectedNull;

    public static OdbcRegistrySpi wrap(OdbcRegistrySpi delegate) {
        return new FailsafeOdbcRegistry(delegate, FailsafeOdbcRegistry::logUnexpectedError, FailsafeOdbcRegistry::logUnexpectedNull);
    }

    @Override
    public String getName() {
        String result;
        try {
            result = this.delegate.getName();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getName");
            this.onUnexpectedError.accept(msg, unexpected);
            return this.getId();
        }
        if (result == null) {
            String msg = this.getUnexpectedNullMsg("getName");
            this.onUnexpectedNull.accept(msg);
            return this.getId();
        }
        return result;
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.delegate.isAvailable();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("isAvailable");
            this.onUnexpectedError.accept(msg, unexpected);
            return false;
        }
    }

    @Override
    public int getCost() {
        try {
            return this.delegate.getCost();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getCost");
            this.onUnexpectedError.accept(msg, unexpected);
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public List<String> getDataSourceNames(OdbcDataSource.Type[] types) throws IOException {
        List<String> result;
        Objects.requireNonNull(types);
        try {
            result = this.delegate.getDataSourceNames(types);
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getDataSourceNames");
            this.onUnexpectedError.accept(msg, unexpected);
            throw new IOException(msg, unexpected);
        }
        if (result == null) {
            String msg = this.getUnexpectedNullMsg("getDataSourceNames");
            this.onUnexpectedNull.accept(msg);
            throw new IOException(msg);
        }
        return result;
    }

    @Override
    public List<OdbcDataSource> getDataSources(OdbcDataSource.Type[] types) throws IOException {
        List<OdbcDataSource> result;
        Objects.requireNonNull(types);
        try {
            result = this.delegate.getDataSources(types);
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getDataSources");
            this.onUnexpectedError.accept(msg, unexpected);
            throw new IOException(msg, unexpected);
        }
        if (result == null) {
            String msg = this.getUnexpectedNullMsg("getDataSources");
            this.onUnexpectedNull.accept(msg);
            throw new IOException(msg);
        }
        return result;
    }

    @Override
    public List<String> getDriverNames() throws IOException {
        List<String> result;
        try {
            result = this.delegate.getDriverNames();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getDriverNames");
            this.onUnexpectedError.accept(msg, unexpected);
            throw new IOException(msg, unexpected);
        }
        if (result == null) {
            String msg = this.getUnexpectedNullMsg("getDriverNames");
            this.onUnexpectedNull.accept(msg);
            throw new IOException(msg);
        }
        return result;
    }

    @Override
    public List<OdbcDriver> getDrivers() throws IOException {
        List<OdbcDriver> result;
        try {
            result = this.delegate.getDrivers();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getDrivers");
            this.onUnexpectedError.accept(msg, unexpected);
            throw new IOException(msg, unexpected);
        }
        if (result == null) {
            String msg = this.getUnexpectedNullMsg("getDrivers");
            this.onUnexpectedNull.accept(msg);
            throw new IOException(msg);
        }
        return result;
    }

    private String getId() {
        return this.delegate.getClass().getName();
    }

    private String getUnexpectedErrorMsg(String method) {
        return "Unexpected error while calling '" + method + "' on '" + this.getId() + "'";
    }

    private String getUnexpectedNullMsg(String method) {
        return "Unexpected null while calling '" + method + "' on '" + this.getId() + "'";
    }

    private static void logUnexpectedError(String msg, RuntimeException ex) {
        log.log(Level.WARNING, msg, ex);
    }

    private static void logUnexpectedNull(String msg) {
        log.log(Level.WARNING, msg);
    }

    public FailsafeOdbcRegistry(@NonNull OdbcRegistrySpi delegate, @NonNull BiConsumer<? super String, ? super RuntimeException> onUnexpectedError, @NonNull Consumer<? super String> onUnexpectedNull) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (onUnexpectedError == null) {
            throw new NullPointerException("onUnexpectedError is marked non-null but is null");
        }
        if (onUnexpectedNull == null) {
            throw new NullPointerException("onUnexpectedNull is marked non-null but is null");
        }
        this.delegate = delegate;
        this.onUnexpectedError = onUnexpectedError;
        this.onUnexpectedNull = onUnexpectedNull;
    }
}

