/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import _test.io.IOIteratorFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import nbbrd.io.IOIterator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;

public class IOIteratorAssertions {
    public static <E> void assertApi(Supplier<IOIterator<E>> iterable) throws IOException {
        IOIteratorAssertions.assertNPE(iterable);
        IOIteratorAssertions.assertIteratorBehavior(iterable);
    }

    private static <E> void assertNPE(Supplier<IOIterator<E>> iterable) {
        IOIterator iterator = iterable.get();
        Assertions.assertThatNullPointerException().isThrownBy(() -> iterator.forEachRemainingWithIO(null));
    }

    private static <E> void assertIteratorBehavior(Supplier<IOIterator<E>> iterable) throws IOException {
        IOIterator<E> iterator = iterable.get();
        IOIteratorFactory.browseNext(iterator);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> iterator.hasNextWithIO()).as("Subsequent calls to hasNextWithIO have no effects", new Object[0])).doesNotThrowAnyException();
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(NoSuchElementException.class).as("Iterator should throw NoSuchElementException if no more elements", new Object[0])).isThrownBy(() -> iterator.nextWithIO());
    }

    @SafeVarargs
    public static <E> void assertContent(Supplier<IOIterator<E>> iterable, E ... content) throws IOException {
        Assertions.assertThat((Iterator)iterable.get().asUnchecked()).toIterable().containsExactly((Object[])content);
        Assertions.assertThat((Stream)iterable.get().asStream()).containsExactly((Object[])content);
        Assertions.assertThat(IOIteratorAssertions.remainingToList(iterable.get())).containsExactly((Object[])content);
        if (content.length > 0) {
            IOIterator<E> iter1 = iterable.get();
            for (E element : content) {
                Assertions.assertThat((Object)iter1.nextWithIO()).isEqualTo(element);
            }
            IOIterator<E> iter2 = iterable.get();
            iter2.nextWithIO();
            Assertions.assertThat(IOIteratorAssertions.remainingToList(iter2)).containsExactly((Object[])Arrays.copyOfRange(content, 1, content.length));
        }
    }

    private static <E> List<E> remainingToList(IOIterator<E> iterator) throws IOException {
        ArrayList result = new ArrayList();
        iterator.forEachRemainingWithIO(result::add);
        return result;
    }
}

