/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.sys;

import internal.io.text.InternalTextResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import lombok.Generated;
import nbbrd.io.text.TextResource;

public final class EndOfProcessException
extends IOException {
    private final int exitValue;
    private final String errorMessage;

    public static EndOfProcessException of(Process process) throws IOException {
        return new EndOfProcessException(process.exitValue(), EndOfProcessException.readErrorStream(process));
    }

    private EndOfProcessException(int exitValue, String errorMessage) {
        super("Invalid exit value: " + exitValue + " " + errorMessage);
        this.exitValue = exitValue;
        this.errorMessage = errorMessage;
    }

    private static String readErrorStream(Process process) throws IOException {
        try (BufferedReader reader = TextResource.newBufferedReader(process.getErrorStream(), Charset.defaultCharset().newDecoder());){
            String string = InternalTextResource.copyByLineToString(reader, System.lineSeparator());
            return string;
        }
    }

    @Generated
    public int getExitValue() {
        return this.exitValue;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

