/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import internal.heylogs.cli.FormatCandidates;
import internal.heylogs.cli.MarkdownInputSupport;
import java.io.BufferedWriter;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileOutputOptions;
import nbbrd.console.picocli.MultiFileInputOptions;
import nbbrd.console.picocli.text.TextOutputSupport;
import nbbrd.heylogs.Scanner;
import picocli.CommandLine;

@CommandLine.Command(name="scan", description={"Summarize changelog content."})
public final class ScanCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private MultiFileInputOptions input;
    @CommandLine.Mixin
    private FileOutputOptions output;
    @CommandLine.Option(names={"-f", "--format"}, paramLabel="<name>", defaultValue="stylish", description={"Specify the format used to control the appearance of the result. Valid values: ${COMPLETION-CANDIDATES}."}, completionCandidates=FormatCandidates.class)
    private String formatId;
    @CommandLine.Option(names={"--debug"}, defaultValue="false", hidden=true)
    private boolean debug;

    @Override
    public Void call() throws Exception {
        try (BufferedWriter writer = TextOutputSupport.newTextOutputSupport(new CommandSupporter[0]).newBufferedWriter(this.output.getFile());){
            Scanner scanner = this.getScanner();
            MarkdownInputSupport markdown = MarkdownInputSupport.newMarkdownInputSupport(new CommandSupporter[0]);
            for (Path file : this.input.getAllFiles(markdown::accept)) {
                scanner.formatStatus(writer, markdown.getName(file), scanner.scan(markdown.readDocument(file)));
            }
        }
        return null;
    }

    private Scanner getScanner() {
        return Scanner.ofServiceLoader().toBuilder().formatId(this.formatId).build();
    }
}

