/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import internal.heylogs.SemverRule;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import nbbrd.heylogs.Checker;
import nbbrd.heylogs.spi.Format;
import nbbrd.heylogs.spi.Rule;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List available resources."})
public final class ListCommand
implements Callable<Void> {
    @CommandLine.Option(names={"-s", "--semver"}, defaultValue="false", description={"Mention if this changelog follows Semantic Versioning."})
    private boolean semver;
    @CommandLine.Option(names={"--debug"}, defaultValue="false", hidden=true)
    private boolean debug;

    @Override
    public Void call() {
        Checker checker = this.getChecker();
        System.out.println("Rules: " + checker.getRules().stream().map(Rule::getId).collect(Collectors.joining(", ")));
        System.out.println("Formats: " + checker.getFormats().stream().map(Format::getId).collect(Collectors.joining(", ")));
        return null;
    }

    private Checker getChecker() {
        Checker.Builder result = Checker.ofServiceLoader().toBuilder();
        if (this.semver) {
            result.rule(new SemverRule());
        }
        return result.build();
    }
}

