/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import com.vladsch.flexmark.util.ast.Document;
import internal.heylogs.cli.MarkdownInputSupport;
import internal.heylogs.cli.MarkdownOutputSupport;
import java.io.IOException;
import java.time.LocalDate;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileInputParameters;
import nbbrd.console.picocli.FileOutputOptions;
import nbbrd.heylogs.Extractor;
import nbbrd.heylogs.TimeRange;
import picocli.CommandLine;

@CommandLine.Command(name="extract", description={"Extract versions from changelog."})
public final class ExtractCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private FileInputParameters input;
    @CommandLine.Mixin
    private FileOutputOptions output;
    @CommandLine.Option(names={"-r", "--ref"}, paramLabel="<ref>", description={"Filter versions by name."})
    private String ref = Extractor.DEFAULT.getRef();
    @CommandLine.Option(names={"-u", "--unreleased"}, paramLabel="<pattern>", description={"Assume that versions that match this pattern are unreleased."})
    private Pattern unreleasedPattern = Extractor.DEFAULT.getUnreleasedPattern();
    @CommandLine.Option(names={"-f", "--from"}, paramLabel="<date>", description={"Filter versions by min date (included)."}, converter={LenientDateConverter.class})
    private LocalDate from = Extractor.DEFAULT.getTimeRange().getFrom();
    @CommandLine.Option(names={"-t", "--to"}, paramLabel="<date>", description={"Filter versions by max date (included)."}, converter={LenientDateConverter.class})
    private LocalDate to = Extractor.DEFAULT.getTimeRange().getTo();
    @CommandLine.Option(names={"-l", "--limit"}, description={"Limit the number of versions."})
    private int limit = Extractor.DEFAULT.getLimit();
    @CommandLine.Option(names={"--ignore-content"}, description={"Ignore versions content, keep headers only."})
    private boolean ignoreContent = false;
    @CommandLine.Option(names={"--debug"}, defaultValue="false", hidden=true)
    private boolean debug;

    @Override
    public Void call() throws Exception {
        this.store(this.extract(this.load()));
        return null;
    }

    private Document load() throws IOException {
        return MarkdownInputSupport.newMarkdownInputSupport(new CommandSupporter[0]).readDocument(this.input.getFile());
    }

    private Document extract(Document document) {
        this.getExtractor().extract(document);
        return document;
    }

    private void store(Document document) throws IOException {
        MarkdownOutputSupport.newMarkdownOutputSupport(new CommandSupporter[0]).writeDocument(this.output.getFile(), document);
    }

    public Extractor getExtractor() {
        return Extractor.builder().ref(this.ref).unreleasedPattern(this.unreleasedPattern).timeRange(TimeRange.of(this.from, this.to)).limit(this.limit).ignoreContent(this.ignoreContent).build();
    }

    private static final class LenientDateConverter
    implements CommandLine.ITypeConverter<LocalDate> {
        private LenientDateConverter() {
        }

        @Override
        public LocalDate convert(String value) {
            return Extractor.parseLocalDate(value);
        }
    }
}

