/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import internal.heylogs.SemverRule;
import internal.heylogs.cli.FormatCandidates;
import internal.heylogs.cli.MarkdownInputSupport;
import java.io.BufferedWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileOutputOptions;
import nbbrd.console.picocli.MultiFileInputOptions;
import nbbrd.console.picocli.text.TextOutputSupport;
import nbbrd.heylogs.Checker;
import nbbrd.heylogs.Failure;
import picocli.CommandLine;

@CommandLine.Command(name="check", description={"Check changelog format."})
public final class CheckCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private MultiFileInputOptions input;
    @CommandLine.Mixin
    private FileOutputOptions output;
    @CommandLine.Option(names={"-s", "--semver"}, defaultValue="false", description={"Mention if this changelog follows Semantic Versioning."})
    private boolean semver;
    @CommandLine.Option(names={"-f", "--format"}, paramLabel="<name>", defaultValue="stylish", description={"Specify the format used to control the appearance of the result. Valid values: ${COMPLETION-CANDIDATES}."}, completionCandidates=FormatCandidates.class)
    private String formatId;
    @CommandLine.Option(names={"--debug"}, defaultValue="false", hidden=true)
    private boolean debug;

    @Override
    public Integer call() throws Exception {
        try (BufferedWriter writer = TextOutputSupport.newTextOutputSupport(new CommandSupporter[0]).newBufferedWriter(this.output.getFile());){
            Checker checker = this.getChecker();
            MarkdownInputSupport markdown = MarkdownInputSupport.newMarkdownInputSupport(new CommandSupporter[0]);
            int failureCount = 0;
            for (Path file : this.input.getAllFiles(markdown::accept)) {
                List<Failure> failures = checker.validate(markdown.readDocument(file));
                checker.formatFailures(writer, markdown.getName(file), failures);
                failureCount += failures.size();
            }
            Integer n = failureCount;
            return n;
        }
    }

    private Checker getChecker() {
        Checker.Builder result = Checker.ofServiceLoader().toBuilder().formatId(this.formatId);
        if (this.semver) {
            result.rule(new SemverRule());
        }
        return result.build();
    }
}

