/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import nbbrd.design.VisibleForTesting;
import nbbrd.heylogs.BaseSection;
import nbbrd.heylogs.Util;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Version
implements BaseSection {
    @VisibleForTesting
    static final char HYPHEN = '-';
    @VisibleForTesting
    static final char EN_DASH = '\u2013';
    @VisibleForTesting
    static final char EM_DASH = '\u2014';
    private static final int HEADING_LEVEL = 2;
    private static final String UNRELEASED_KEYWORD = "unreleased";
    private static final char UNRELEASED_SEPARATOR = '-';
    private static final LocalDate UNRELEASED_DATE = LocalDate.MAX;
    private static final CharPredicate VALID_SEPARATOR = CharPredicate.anyOf('-', '\u2013', '\u2014');
    @lombok.NonNull
    private final String ref;
    private final char separator;
    @lombok.NonNull
    private final LocalDate date;

    public boolean isUnreleased() {
        return UNRELEASED_KEYWORD.equalsIgnoreCase(this.ref);
    }

    public String toString() {
        return "Version(ref=" + this.ref + ", separator=" + Util.toUnicode(Character.valueOf(this.separator)) + ", date=" + this.date + ")";
    }

    @Override
    @lombok.NonNull
    public Heading toHeading() {
        Heading result = new Heading();
        result.setOpeningMarker(BasedSequence.repeatOf("#", 2));
        result.setLevel(2);
        LinkRef firstPart = new LinkRef();
        firstPart.setReferenceOpeningMarker(BasedSequence.of("["));
        firstPart.setReferenceClosingMarker(BasedSequence.of("]"));
        firstPart.setReference(BasedSequence.of(this.ref));
        result.appendChild(firstPart);
        if (!this.isUnreleased()) {
            Text secondPart = new Text();
            secondPart.setChars((BasedSequence)BasedSequence.of(" " + this.separator + " ").append(this.date.toString()));
            result.appendChild(secondPart);
        }
        return result;
    }

    @lombok.NonNull
    public static Version parse(@lombok.NonNull Heading heading) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        if (!Version.isVersionLevel(heading)) {
            throw new IllegalArgumentException("Invalid heading level");
        }
        ReversiblePeekingIterator<Node> parts = heading.getChildIterator();
        if (!parts.hasNext()) {
            throw new IllegalArgumentException("Missing ref part");
        }
        Node firstPart = (Node)parts.next();
        String ref = Version.parseRef(firstPart);
        if (ref.equalsIgnoreCase(UNRELEASED_KEYWORD)) {
            if (parts.hasNext()) {
                throw new IllegalArgumentException("Unexpected additional part: '" + ((Node)parts.next()).getChars() + "'");
            }
            return new Version(ref, '-', UNRELEASED_DATE);
        }
        if (!parts.hasNext()) {
            throw new IllegalArgumentException("Missing date part");
        }
        Node secondPart = (Node)parts.next();
        char separator = Version.parseSeparator(secondPart);
        LocalDate date = Version.parseDate(secondPart);
        if (parts.hasNext()) {
            throw new IllegalArgumentException("Unexpected additional part: '" + ((Node)parts.next()).getChars() + "'");
        }
        return new Version(ref, separator, date);
    }

    private static String parseRef(Node firstPart) throws IllegalArgumentException {
        if (!(firstPart instanceof LinkRef)) {
            throw new IllegalArgumentException("Missing ref link");
        }
        return ((LinkRef)firstPart).getReference().toString();
    }

    private static char parseSeparator(Node secondPart) throws IllegalArgumentException {
        BasedSequence text = (BasedSequence)secondPart.getChars().trimStart();
        if (!text.startsWith(VALID_SEPARATOR)) {
            throw new IllegalArgumentException("Missing date prefix");
        }
        return text.charAt(0);
    }

    private static LocalDate parseDate(Node secondPart) throws IllegalArgumentException {
        BasedSequence date = secondPart.getChars();
        BasedSequence x = (BasedSequence)((BasedSequence)date.safeSubSequence(3)).trim();
        try {
            return LocalDate.parse(x);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("Invalid date format");
        }
    }

    public static boolean isVersionLevel(Heading heading) {
        return heading.getLevel() == 2;
    }

    @Generated
    private Version(@lombok.NonNull String ref, char separator, @lombok.NonNull LocalDate date) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.ref = ref;
        this.separator = separator;
        this.date = date;
    }

    @Generated
    public static @NonNull Version of(@lombok.NonNull String ref, char separator, @lombok.NonNull LocalDate date) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return new Version(ref, separator, date);
    }

    @lombok.NonNull
    @Generated
    public String getRef() {
        return this.ref;
    }

    @Generated
    public char getSeparator() {
        return this.separator;
    }

    @lombok.NonNull
    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (this.getSeparator() != other.getSeparator()) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeparator();
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }
}

