/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import java.util.Locale;
import java.util.function.Function;
import lombok.NonNull;

public final class Util {
    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @NonNull
    public static <X, Y> Function<X, Y> illegalArgumentToNull(Function<X, Y> function) {
        return x -> {
            try {
                return function.apply(x);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        };
    }

    @NonNull
    public static String toUnicode(@NonNull Character c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        return String.format(Locale.ROOT, "\\u%04x", (int)c.charValue());
    }
}

