/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.BaseSection;

public enum TypeOfChange implements BaseSection
{
    ADDED("Added"),
    CHANGED("Changed"),
    DEPRECATED("Deprecated"),
    REMOVED("Removed"),
    FIXED("Fixed"),
    SECURITY("Security");

    private static final int HEADING_LEVEL = 3;
    final String label;

    @Override
    @NonNull
    public Heading toHeading() {
        Heading result = new Heading();
        result.setOpeningMarker(BasedSequence.repeatOf("#", 3));
        result.setLevel(3);
        result.appendChild(new Text(BasedSequence.of(this.label)));
        return result;
    }

    @NonNull
    public static TypeOfChange parse(@NonNull Heading heading) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        if (!TypeOfChange.isTypeOfChangeLevel(heading)) {
            throw new IllegalArgumentException("Invalid heading level");
        }
        return Stream.of(TypeOfChange.values()).filter(value -> value.getLabel().contentEquals(heading.getText())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot parse '" + heading.getText() + "'"));
    }

    public static boolean isTypeOfChangeLevel(Heading heading) {
        return heading.getLevel() == 3;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    private TypeOfChange(String label) {
        this.label = label;
    }
}

