/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.util.ast.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Status;
import nbbrd.heylogs.TimeRange;
import nbbrd.heylogs.Util;
import nbbrd.heylogs.Version;
import nbbrd.heylogs.spi.Format;
import nbbrd.heylogs.spi.FormatLoader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.semver4j.Semver;

public final class Scanner {
    @NonNull
    private final List<Format> formats;
    @NonNull
    private final String formatId;
    private static final String FIRST_FORMAT_AVAILABLE = "";

    @NonNull
    public static Scanner ofServiceLoader() {
        return Scanner.builder().formats(FormatLoader.load()).build();
    }

    @NonNull
    public Status scan(@NonNull Node document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        Map<Boolean, List<Version>> versionByType = Nodes.of(Heading.class).descendants(document).filter(Version::isVersionLevel).map(Util.illegalArgumentToNull(Version::parse)).filter(Objects::nonNull).collect(Collectors.partitioningBy(Version::isUnreleased));
        boolean compatibleWithSemver = Scanner.isCompatibleWithSemver(versionByType.get(false));
        return Status.builder().releaseCount(versionByType.get(false).size()).timeRange(versionByType.get(false).stream().map(Version::getDate).collect(TimeRange.toTimeRange()).orElse(TimeRange.ALL)).compatibleWithSemver(compatibleWithSemver).semverDetails(compatibleWithSemver ? Scanner.getDetails(versionByType.get(false)) : FIRST_FORMAT_AVAILABLE).hasUnreleasedSection(versionByType.containsKey(true)).build();
    }

    private static boolean isCompatibleWithSemver(List<Version> releases) {
        return releases.stream().map(Version::getRef).allMatch(Semver::isValid);
    }

    private static String getDetails(List<Version> releases) {
        List semvers = releases.stream().map(Version::getRef).map(Semver::parse).collect(Collectors.toList());
        TreeMap diffs = IntStream.range(1, semvers.size()).mapToObj(i -> ((Semver)semvers.get(i)).diff((Semver)semvers.get(i - 1))).collect(Collectors.groupingBy(o -> o, TreeMap::new, Collectors.toList()));
        return diffs.descendingMap().entrySet().stream().map(entry -> ((List)entry.getValue()).size() + " " + ((Semver.VersionDiff)((Object)((Object)entry.getKey()))).toString()).collect(Collectors.joining(", ", " (", ")"));
    }

    public void formatStatus(@NonNull Appendable appendable, @NonNull String source, @NonNull Status status) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.getFormatById().formatStatus(appendable, source, status);
    }

    private Format getFormatById() throws IOException {
        return this.formats.stream().filter(format -> this.formatId.equals(FIRST_FORMAT_AVAILABLE) || format.getId().equals(this.formatId)).findFirst().orElseThrow(() -> new IOException("Cannot find format '" + this.formatId + "'"));
    }

    @Generated
    private static String $default$formatId() {
        return FIRST_FORMAT_AVAILABLE;
    }

    @Generated
    Scanner(@NonNull List<Format> formats, @NonNull String formatId) {
        if (formats == null) {
            throw new NullPointerException("formats is marked non-null but is null");
        }
        if (formatId == null) {
            throw new NullPointerException("formatId is marked non-null but is null");
        }
        this.formats = formats;
        this.formatId = formatId;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        Builder builder = new Builder().formatId(this.formatId);
        if (this.formats != null) {
            builder.formats(this.formats);
        }
        return builder;
    }

    @NonNull
    @Generated
    public List<Format> getFormats() {
        return this.formats;
    }

    @NonNull
    @Generated
    public String getFormatId() {
        return this.formatId;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scanner)) {
            return false;
        }
        Scanner other = (Scanner)o;
        List<Format> this$formats = this.getFormats();
        List<Format> other$formats = other.getFormats();
        if (this$formats == null ? other$formats != null : !((Object)this$formats).equals(other$formats)) {
            return false;
        }
        String this$formatId = this.getFormatId();
        String other$formatId = other.getFormatId();
        return !(this$formatId == null ? other$formatId != null : !this$formatId.equals(other$formatId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Format> $formats = this.getFormats();
        result = result * 59 + ($formats == null ? 43 : ((Object)$formats).hashCode());
        String $formatId = this.getFormatId();
        result = result * 59 + ($formatId == null ? 43 : $formatId.hashCode());
        return result;
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "Scanner(formats=" + this.getFormats() + ", formatId=" + this.getFormatId() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<Format> formats;
        @Generated
        private boolean formatId$set;
        @Generated
        private String formatId$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder format(Format format) {
            if (this.formats == null) {
                this.formats = new ArrayList();
            }
            this.formats.add(format);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder formats(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Format> formats) {
            if (formats == null) {
                throw new NullPointerException("formats cannot be null");
            }
            if (this.formats == null) {
                this.formats = new ArrayList();
            }
            this.formats.addAll(formats);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearFormats() {
            if (this.formats != null) {
                this.formats.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder formatId(@NonNull String formatId) {
            if (formatId == null) {
                throw new NullPointerException("formatId is marked non-null but is null");
            }
            this.formatId$value = formatId;
            this.formatId$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Scanner build() {
            List<Format> formats;
            switch (this.formats == null ? 0 : this.formats.size()) {
                case 0: {
                    formats = Collections.emptyList();
                    break;
                }
                case 1: {
                    formats = Collections.singletonList(this.formats.get(0));
                    break;
                }
                default: {
                    formats = Collections.unmodifiableList(new ArrayList<Format>(this.formats));
                }
            }
            String formatId$value = this.formatId$value;
            if (!this.formatId$set) {
                formatId$value = Scanner.$default$formatId();
            }
            return new Scanner(formats, formatId$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "Scanner.Builder(formats=" + this.formats + ", formatId$value=" + this.formatId$value + ")";
        }
    }
}

