/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.util.ast.Node;
import lombok.Generated;
import nbbrd.heylogs.spi.Rule;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Failure {
    @lombok.NonNull
    private final String ruleId;
    @lombok.NonNull
    private final String message;
    private final int line;
    private final int column;

    @Generated
    Failure(@lombok.NonNull String ruleId, @lombok.NonNull String message, int line, int column) {
        if (ruleId == null) {
            throw new NullPointerException("ruleId is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.ruleId = ruleId;
        this.message = message;
        this.line = line;
        this.column = column;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @lombok.NonNull
    @Generated
    public String getRuleId() {
        return this.ruleId;
    }

    @lombok.NonNull
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public int getLine() {
        return this.line;
    }

    @Generated
    public int getColumn() {
        return this.column;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Failure)) {
            return false;
        }
        Failure other = (Failure)o;
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        String this$ruleId = this.getRuleId();
        String other$ruleId = other.getRuleId();
        if (this$ruleId == null ? other$ruleId != null : !this$ruleId.equals(other$ruleId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLine();
        result = result * 59 + this.getColumn();
        String $ruleId = this.getRuleId();
        result = result * 59 + ($ruleId == null ? 43 : $ruleId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Failure(ruleId=" + this.getRuleId() + ", message=" + this.getMessage() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ")";
    }

    public static final class Builder {
        @Generated
        private String ruleId;
        @Generated
        private String message;
        @Generated
        private int line;
        @Generated
        private int column;

        @lombok.NonNull
        public Builder rule(@lombok.NonNull Rule rule) {
            if (rule == null) {
                throw new NullPointerException("rule is marked non-null but is null");
            }
            return this.ruleId(rule.getId());
        }

        @lombok.NonNull
        public Builder location(@lombok.NonNull Node location) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            return this.line(location.getStartLineNumber() + 1).column(location.lineColumnAtStart().getSecond() + 1);
        }

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder ruleId(@lombok.NonNull String ruleId) {
            if (ruleId == null) {
                throw new NullPointerException("ruleId is marked non-null but is null");
            }
            this.ruleId = ruleId;
            return this;
        }

        @Generated
        public @NonNull Builder message(@lombok.NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        @Generated
        public @NonNull Builder line(int line) {
            this.line = line;
            return this;
        }

        @Generated
        public @NonNull Builder column(int column) {
            this.column = column;
            return this;
        }

        @Generated
        public @NonNull Failure build() {
            return new Failure(this.ruleId, this.message, this.line, this.column);
        }

        @Generated
        public @NonNull String toString() {
            return "Failure.Builder(ruleId=" + this.ruleId + ", message=" + this.message + ", line=" + this.line + ", column=" + this.column + ")";
        }
    }
}

