/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.TimeRange;
import nbbrd.heylogs.Version;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Extractor {
    public static final Extractor DEFAULT = Extractor.builder().build();
    @NonNull
    private final String ref;
    @NonNull
    private final Pattern unreleasedPattern;
    @NonNull
    private final TimeRange timeRange;
    private final int limit;
    private final boolean ignoreContent;

    private boolean isUnreleasedPattern() {
        return this.unreleasedPattern.asPredicate().test(this.ref);
    }

    private boolean containsRef(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.isUnreleasedPattern() && version.isUnreleased() || version.getRef().contains(this.ref);
    }

    public boolean contains(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.containsRef(version) && this.timeRange.contains(version.getDate());
    }

    public boolean contains(@NonNull Heading heading) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        return this.contains(Version.parse(heading));
    }

    public void extract(@NonNull Document root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        int found = 0;
        boolean keep = false;
        ArrayList refNodes = new ArrayList();
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Node current : root.getChildren()) {
            boolean versionHeading;
            boolean bl = versionHeading = current instanceof Heading && Version.isVersionLevel((Heading)current);
            if (versionHeading) {
                if (found >= this.getLimit() || !this.contains((Heading)current)) {
                    keep = false;
                } else {
                    ++found;
                    keep = true;
                }
            }
            if (keep) {
                Nodes.of(RefNode.class).descendants(current).map(node -> node.getReference().toString()).forEach(refNodes::add);
                if (!versionHeading || !this.ignoreContent) continue;
                keep = false;
                continue;
            }
            if (current instanceof Reference) {
                references.add((Reference)current);
                continue;
            }
            current.unlink();
        }
        references.stream().filter(reference -> !refNodes.contains(reference.getReference().toString())).forEach(Node::unlink);
    }

    public static LocalDate parseLocalDate(CharSequence input) {
        try {
            return Year.parse(input).atDay(1);
        }
        catch (Exception ex1) {
            try {
                return YearMonth.parse(input).atDay(1);
            }
            catch (Exception ex2) {
                return LocalDate.parse(input);
            }
        }
    }

    @Generated
    private static String $default$ref() {
        return "";
    }

    @Generated
    private static Pattern $default$unreleasedPattern() {
        return Pattern.compile("^.*-SNAPSHOT$");
    }

    @Generated
    private static TimeRange $default$timeRange() {
        return TimeRange.ALL;
    }

    @Generated
    private static int $default$limit() {
        return Integer.MAX_VALUE;
    }

    @Generated
    private static boolean $default$ignoreContent() {
        return false;
    }

    @Generated
    Extractor(@NonNull String ref, @NonNull Pattern unreleasedPattern, @NonNull TimeRange timeRange, int limit, boolean ignoreContent) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (unreleasedPattern == null) {
            throw new NullPointerException("unreleasedPattern is marked non-null but is null");
        }
        if (timeRange == null) {
            throw new NullPointerException("timeRange is marked non-null but is null");
        }
        this.ref = ref;
        this.unreleasedPattern = unreleasedPattern;
        this.timeRange = timeRange;
        this.limit = limit;
        this.ignoreContent = ignoreContent;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        return new Builder().ref(this.ref).unreleasedPattern(this.unreleasedPattern).timeRange(this.timeRange).limit(this.limit).ignoreContent(this.ignoreContent);
    }

    @NonNull
    @Generated
    public String getRef() {
        return this.ref;
    }

    @NonNull
    @Generated
    public Pattern getUnreleasedPattern() {
        return this.unreleasedPattern;
    }

    @NonNull
    @Generated
    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean isIgnoreContent() {
        return this.ignoreContent;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Extractor)) {
            return false;
        }
        Extractor other = (Extractor)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.isIgnoreContent() != other.isIgnoreContent()) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        Pattern this$unreleasedPattern = this.getUnreleasedPattern();
        Pattern other$unreleasedPattern = other.getUnreleasedPattern();
        if (this$unreleasedPattern == null ? other$unreleasedPattern != null : !this$unreleasedPattern.equals(other$unreleasedPattern)) {
            return false;
        }
        TimeRange this$timeRange = this.getTimeRange();
        TimeRange other$timeRange = other.getTimeRange();
        return !(this$timeRange == null ? other$timeRange != null : !((Object)this$timeRange).equals(other$timeRange));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        result = result * 59 + (this.isIgnoreContent() ? 79 : 97);
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        Pattern $unreleasedPattern = this.getUnreleasedPattern();
        result = result * 59 + ($unreleasedPattern == null ? 43 : $unreleasedPattern.hashCode());
        TimeRange $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : ((Object)$timeRange).hashCode());
        return result;
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "Extractor(ref=" + this.getRef() + ", unreleasedPattern=" + this.getUnreleasedPattern() + ", timeRange=" + this.getTimeRange() + ", limit=" + this.getLimit() + ", ignoreContent=" + this.isIgnoreContent() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean ref$set;
        @Generated
        private String ref$value;
        @Generated
        private boolean unreleasedPattern$set;
        @Generated
        private Pattern unreleasedPattern$value;
        @Generated
        private boolean timeRange$set;
        @Generated
        private TimeRange timeRange$value;
        @Generated
        private boolean limit$set;
        @Generated
        private int limit$value;
        @Generated
        private boolean ignoreContent$set;
        @Generated
        private boolean ignoreContent$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder ref(@NonNull String ref) {
            if (ref == null) {
                throw new NullPointerException("ref is marked non-null but is null");
            }
            this.ref$value = ref;
            this.ref$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder unreleasedPattern(@NonNull Pattern unreleasedPattern) {
            if (unreleasedPattern == null) {
                throw new NullPointerException("unreleasedPattern is marked non-null but is null");
            }
            this.unreleasedPattern$value = unreleasedPattern;
            this.unreleasedPattern$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder timeRange(@NonNull TimeRange timeRange) {
            if (timeRange == null) {
                throw new NullPointerException("timeRange is marked non-null but is null");
            }
            this.timeRange$value = timeRange;
            this.timeRange$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder limit(int limit) {
            this.limit$value = limit;
            this.limit$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder ignoreContent(boolean ignoreContent) {
            this.ignoreContent$value = ignoreContent;
            this.ignoreContent$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Extractor build() {
            String ref$value = this.ref$value;
            if (!this.ref$set) {
                ref$value = Extractor.$default$ref();
            }
            Pattern unreleasedPattern$value = this.unreleasedPattern$value;
            if (!this.unreleasedPattern$set) {
                unreleasedPattern$value = Extractor.$default$unreleasedPattern();
            }
            TimeRange timeRange$value = this.timeRange$value;
            if (!this.timeRange$set) {
                timeRange$value = Extractor.$default$timeRange();
            }
            int limit$value = this.limit$value;
            if (!this.limit$set) {
                limit$value = Extractor.$default$limit();
            }
            boolean ignoreContent$value = this.ignoreContent$value;
            if (!this.ignoreContent$set) {
                ignoreContent$value = Extractor.$default$ignoreContent();
            }
            return new Extractor(ref$value, unreleasedPattern$value, timeRange$value, limit$value, ignoreContent$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "Extractor.Builder(ref$value=" + this.ref$value + ", unreleasedPattern$value=" + this.unreleasedPattern$value + ", timeRange$value=" + this.timeRange$value + ", limit$value=" + this.limit$value + ", ignoreContent$value=" + this.ignoreContent$value + ")";
        }
    }
}

