/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.spi.Format;
import nbbrd.heylogs.spi.FormatLoader;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleLoader;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Checker {
    @NonNull
    private final List<Rule> rules;
    @NonNull
    private final List<Format> formats;
    @NonNull
    private final String formatId;
    private static final String FIRST_FORMAT_AVAILABLE = "";

    @NonNull
    public static Checker ofServiceLoader() {
        return Checker.builder().rules(RuleLoader.load()).formats(FormatLoader.load()).build();
    }

    @NonNull
    public List<Failure> validate(@NonNull Document doc) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        return Stream.concat(Stream.of(doc), Nodes.of(Node.class).descendants(doc)).flatMap(node -> this.rules.stream().map(rule -> rule.validate((Node)node)).filter(Objects::nonNull)).collect(Collectors.toList());
    }

    public void formatFailures(@NonNull Appendable appendable, @NonNull String source, @NonNull List<Failure> failures) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (failures == null) {
            throw new NullPointerException("failures is marked non-null but is null");
        }
        this.getFormatById().formatFailures(appendable, source, failures);
    }

    private Format getFormatById() throws IOException {
        return this.formats.stream().filter(format -> this.formatId.equals(FIRST_FORMAT_AVAILABLE) || format.getId().equals(this.formatId)).findFirst().orElseThrow(() -> new IOException("Cannot find format '" + this.formatId + "'"));
    }

    @Generated
    private static String $default$formatId() {
        return FIRST_FORMAT_AVAILABLE;
    }

    @Generated
    Checker(@NonNull List<Rule> rules, @NonNull List<Format> formats, @NonNull String formatId) {
        if (rules == null) {
            throw new NullPointerException("rules is marked non-null but is null");
        }
        if (formats == null) {
            throw new NullPointerException("formats is marked non-null but is null");
        }
        if (formatId == null) {
            throw new NullPointerException("formatId is marked non-null but is null");
        }
        this.rules = rules;
        this.formats = formats;
        this.formatId = formatId;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        Builder builder = new Builder().formatId(this.formatId);
        if (this.rules != null) {
            builder.rules(this.rules);
        }
        if (this.formats != null) {
            builder.formats(this.formats);
        }
        return builder;
    }

    @NonNull
    @Generated
    public List<Rule> getRules() {
        return this.rules;
    }

    @NonNull
    @Generated
    public List<Format> getFormats() {
        return this.formats;
    }

    @NonNull
    @Generated
    public String getFormatId() {
        return this.formatId;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Checker)) {
            return false;
        }
        Checker other = (Checker)o;
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        List<Format> this$formats = this.getFormats();
        List<Format> other$formats = other.getFormats();
        if (this$formats == null ? other$formats != null : !((Object)this$formats).equals(other$formats)) {
            return false;
        }
        String this$formatId = this.getFormatId();
        String other$formatId = other.getFormatId();
        return !(this$formatId == null ? other$formatId != null : !this$formatId.equals(other$formatId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        List<Format> $formats = this.getFormats();
        result = result * 59 + ($formats == null ? 43 : ((Object)$formats).hashCode());
        String $formatId = this.getFormatId();
        result = result * 59 + ($formatId == null ? 43 : $formatId.hashCode());
        return result;
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "Checker(rules=" + this.getRules() + ", formats=" + this.getFormats() + ", formatId=" + this.getFormatId() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<Rule> rules;
        @Generated
        private ArrayList<Format> formats;
        @Generated
        private boolean formatId$set;
        @Generated
        private String formatId$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder rule(Rule rule) {
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.add(rule);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder rules(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Rule> rules) {
            if (rules == null) {
                throw new NullPointerException("rules cannot be null");
            }
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.addAll(rules);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearRules() {
            if (this.rules != null) {
                this.rules.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder format(Format format) {
            if (this.formats == null) {
                this.formats = new ArrayList();
            }
            this.formats.add(format);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder formats(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Format> formats) {
            if (formats == null) {
                throw new NullPointerException("formats cannot be null");
            }
            if (this.formats == null) {
                this.formats = new ArrayList();
            }
            this.formats.addAll(formats);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearFormats() {
            if (this.formats != null) {
                this.formats.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder formatId(@NonNull String formatId) {
            if (formatId == null) {
                throw new NullPointerException("formatId is marked non-null but is null");
            }
            this.formatId$value = formatId;
            this.formatId$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Checker build() {
            List<Format> formats;
            List<Rule> rules;
            switch (this.rules == null ? 0 : this.rules.size()) {
                case 0: {
                    rules = Collections.emptyList();
                    break;
                }
                case 1: {
                    rules = Collections.singletonList(this.rules.get(0));
                    break;
                }
                default: {
                    rules = Collections.unmodifiableList(new ArrayList<Rule>(this.rules));
                }
            }
            switch (this.formats == null ? 0 : this.formats.size()) {
                case 0: {
                    formats = Collections.emptyList();
                    break;
                }
                case 1: {
                    formats = Collections.singletonList(this.formats.get(0));
                    break;
                }
                default: {
                    formats = Collections.unmodifiableList(new ArrayList<Format>(this.formats));
                }
            }
            String formatId$value = this.formatId$value;
            if (!this.formatId$set) {
                formatId$value = Checker.$default$formatId();
            }
            return new Checker(rules, formats, formatId$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "Checker.Builder(rules=" + this.rules + ", formats=" + this.formats + ", formatId$value=" + this.formatId$value + ")";
        }
    }
}

