/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.properties;

import internal.console.properties.ConsolePropertiesSpiLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConsoleProperties {
    private final List<Spi> providers;

    public static @NonNull ConsoleProperties ofServiceLoader() {
        return ConsoleProperties.builder().providers(new ConsolePropertiesSpiLoader().get()).build();
    }

    public @NonNull Optional<Charset> getStdInEncoding() {
        return this.providers.stream().map(Spi::getStdInEncodingOrNull).filter(Objects::nonNull).findFirst();
    }

    public @NonNull Optional<Charset> getStdOutEncoding() {
        return this.providers.stream().map(Spi::getStdOutEncodingOrNull).filter(Objects::nonNull).findFirst();
    }

    public @NonNull OptionalInt getColumns() {
        return this.providers.stream().mapToInt(Spi::getColumns).filter(this::isNotNegative).findFirst();
    }

    public @NonNull OptionalInt getRows() {
        return this.providers.stream().mapToInt(Spi::getRows).filter(this::isNotNegative).findFirst();
    }

    private boolean isNotNegative(int value) {
        return value >= 0;
    }

    @Generated
    ConsoleProperties(List<Spi> providers) {
        this.providers = providers;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @NonNull Builder toBuilder() {
        Builder builder = new Builder();
        if (this.providers != null) {
            builder.providers(this.providers);
        }
        return builder;
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<Spi> providers;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder provider(Spi provider) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.add(provider);
            return this;
        }

        @Generated
        public @NonNull Builder providers(@NonNull Collection<? extends Spi> providers) {
            if (providers == null) {
                throw new NullPointerException("providers cannot be null");
            }
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.addAll(providers);
            return this;
        }

        @Generated
        public @NonNull Builder clearProviders() {
            if (this.providers != null) {
                this.providers.clear();
            }
            return this;
        }

        @Generated
        public @NonNull ConsoleProperties build() {
            List<Spi> providers;
            switch (this.providers == null ? 0 : this.providers.size()) {
                case 0: {
                    providers = Collections.emptyList();
                    break;
                }
                case 1: {
                    providers = Collections.singletonList(this.providers.get(0));
                    break;
                }
                default: {
                    providers = Collections.unmodifiableList(new ArrayList<Spi>(this.providers));
                }
            }
            return new ConsoleProperties(providers);
        }

        @Generated
        public @NonNull String toString() {
            return "ConsoleProperties.Builder(providers=" + this.providers + ")";
        }
    }

    public static interface Spi {
        public static final int UNKNOWN_RANK = Integer.MAX_VALUE;
        public static final int UNKNOWN_COLUMNS = -1;
        public static final int UNKNOWN_ROWS = -1;

        public boolean isAvailable();

        public int getRank();

        public @Nullable Charset getStdInEncodingOrNull();

        public @Nullable Charset getStdOutEncodingOrNull();

        public int getColumns();

        public int getRows();
    }
}

