/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.yaml;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import nbbrd.console.picocli.text.TextOutput;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public interface YamlOutput
extends TextOutput {
    default public void dump(Yaml yaml, Object item) throws IOException {
        try (Writer writer = this.newCharWriter();){
            yaml.dump(item, writer);
        }
    }

    default public void dumpAll(Yaml yaml, Collection<?> items) throws IOException {
        try (Writer writer = this.newCharWriter();){
            yaml.dumpAll(items.iterator(), writer);
        }
    }

    public static PropertyUtils newLinkedPropertyUtils() {
        return new PropertyUtils(){

            protected Set<Property> createPropertySet(Class<? extends Object> type, BeanAccess bAccess) {
                return this.getPropertiesMap(type, bAccess).values().stream().filter(property -> property.isReadable() && (this.isAllowReadOnlyProperties() || property.isWritable())).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        };
    }
}

