/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.ByteInputSupport;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.text.CharsetSupplier;
import nbbrd.io.text.TextBuffers;

public class TextInputSupport
extends ByteInputSupport {
    @NonNull
    private CharsetSupplier fileEncoding = CharsetSupplier.ofName("UTF-8");
    @NonNull
    private CharsetSupplier stdinEncoding = CharsetSupplier.ofStdin();

    @SafeVarargs
    @NonNull
    public static TextInputSupport newTextInputSupport(CommandSupporter<? super TextInputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(TextInputSupport::new, supporters);
    }

    @NonNull
    public CharsetDecoder newDecoder(@NonNull Path file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.isStdInFile(file) ? this.stdinEncoding.getCharset().newDecoder() : this.fileEncoding.getCharset().newDecoder();
    }

    @NonNull
    public BufferedReader newBufferedReader(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        CharsetDecoder decoder = this.newDecoder(file);
        return new BufferedReader(this.newInputStreamReader(file, decoder), this.getCharBufferSize(file, decoder));
    }

    @NonNull
    public String readString(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (BufferedReader reader = this.newBufferedReader(file);){
            String string = TextInputSupport.readString(reader);
            return string;
        }
    }

    protected InputStreamReader newInputStreamReader(Path file, CharsetDecoder decoder) throws IOException {
        return new InputStreamReader(this.newInputStream(file), decoder);
    }

    protected int getCharBufferSize(Path file, CharsetDecoder decoder) throws IOException {
        return (this.isStdInFile(file) ? TextBuffers.UNKNOWN : TextBuffers.of(file, decoder)).getCharBufferSize();
    }

    static String readString(Reader reader) throws IOException {
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[8192];
        int readCount = 0;
        while ((readCount = reader.read(buffer)) != -1) {
            result.append(buffer, 0, readCount);
        }
        return result.toString();
    }

    @NonNull
    @Generated
    public CharsetSupplier getFileEncoding() {
        return this.fileEncoding;
    }

    @NonNull
    @Generated
    public CharsetSupplier getStdinEncoding() {
        return this.stdinEncoding;
    }

    @Generated
    public void setFileEncoding(@NonNull CharsetSupplier fileEncoding) {
        if (fileEncoding == null) {
            throw new NullPointerException("fileEncoding is marked non-null but is null");
        }
        this.fileEncoding = fileEncoding;
    }

    @Generated
    public void setStdinEncoding(@NonNull CharsetSupplier stdinEncoding) {
        if (stdinEncoding == null) {
            throw new NullPointerException("stdinEncoding is marked non-null but is null");
        }
        this.stdinEncoding = stdinEncoding;
    }

    @Generated
    protected TextInputSupport() {
    }
}

