/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import nbbrd.console.picocli.Profilable;
import nbbrd.console.picocli.StandardCharsetCandidates;
import nbbrd.console.picocli.text.TextInput;
import nbbrd.console.properties.ConsoleProperties;
import picocli.CommandLine;

public class TextInputOptions
implements TextInput,
Profilable {
    @CommandLine.Option(names={"-i", "--input"}, paramLabel="<file>", description={"Input from a file instead of stdin."})
    private Path file;
    @CommandLine.Option(names={"-z", "--gzipped"}, description={"Uncompress the output file with gzip."}, defaultValue="false")
    private boolean gzipped;
    @CommandLine.Option(names={"-e", "--encoding"}, paramLabel="<encoding>", description={"Charset used to encode text."}, completionCandidates=StandardCharsetCandidates.class, defaultValue="UTF-8")
    private Charset encoding;

    @Override
    public InputStream getStdInStream() {
        return System.in;
    }

    @Override
    public Charset getStdInEncoding() {
        return ConsoleProperties.ofServiceLoader().getStdInEncoding().orElse(StandardCharsets.UTF_8);
    }

    @Override
    @Generated
    public Path getFile() {
        return this.file;
    }

    @Override
    @Generated
    public boolean isGzipped() {
        return this.gzipped;
    }

    @Override
    @Generated
    public Charset getEncoding() {
        return this.encoding;
    }

    @Generated
    public void setFile(Path file) {
        this.file = file;
    }

    @Generated
    public void setGzipped(boolean gzipped) {
        this.gzipped = gzipped;
    }

    @Generated
    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }
}

