/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public interface ObsFormat {
    public Locale getLocale();

    public String getDatePattern();

    public String getDatetimePattern();

    public String getNumberPattern();

    public boolean isIgnoreNumberGrouping();

    default public DateTimeFormatter newDateTimeFormatter(boolean includeTime) throws IllegalArgumentException {
        String pattern = includeTime ? this.getDatetimePattern() : this.getDatePattern();
        return DateTimeFormatter.ofPattern(pattern, this.getLocale());
    }

    default public NumberFormat newNumberFormat() throws IllegalArgumentException {
        DecimalFormat result = new DecimalFormat(this.getNumberPattern(), DecimalFormatSymbols.getInstance(this.getLocale()));
        if (this.isIgnoreNumberGrouping()) {
            ((NumberFormat)result).setGroupingUsed(false);
        }
        return result;
    }
}

