/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.nio.charset.Charset;
import nbbrd.console.properties.ConsoleProperties;

@FunctionalInterface
public interface CharsetSupplier {
    public static final String DEFAULT_ENCODING = "UTF-8";

    public Charset getCharset();

    public static CharsetSupplier getDefault() {
        return CharsetSupplier.ofName(DEFAULT_ENCODING);
    }

    public static CharsetSupplier of(Charset charset) {
        return () -> charset;
    }

    public static CharsetSupplier ofName(String charsetName) {
        return () -> Charset.forName(charsetName);
    }

    public static CharsetSupplier ofStdin() {
        return () -> ConsoleProperties.ofServiceLoader().getStdInEncoding().orElseGet(() -> Charset.forName(DEFAULT_ENCODING));
    }

    public static CharsetSupplier ofStdout() {
        return () -> ConsoleProperties.ofServiceLoader().getStdOutEncoding().orElseGet(() -> Charset.forName(DEFAULT_ENCODING));
    }
}

